/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.JmxTreeWatcherMBean;
import io.hawt.util.Objects;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTreeWatcher
implements JmxTreeWatcherMBean {
    private static final Logger LOG = LoggerFactory.getLogger(JmxTreeWatcher.class);
    private static final AtomicBoolean logged = new AtomicBoolean();
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private final AtomicLong counter = new AtomicLong(0L);
    private NotificationListener listener;
    private String version;

    public void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = this.getObjectName();
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            this.listener = this.getNotificationListener();
            NotificationFilter filter = this.getNotificationFilter();
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, filter, null);
        }
        if (logged.compareAndSet(false, true)) {
            LOG.info("Welcome to Hawtio {}", (Object)this.getVersion());
        }
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null) {
            if (this.listener != null) {
                this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener);
            }
            if (this.objectName != null) {
                try {
                    this.mBeanServer.unregisterMBean(this.objectName);
                }
                catch (InstanceNotFoundException e) {
                    LOG.debug("Error unregistering mbean " + String.valueOf(this.objectName) + ". This exception is ignored.", (Throwable)e);
                }
            }
        }
    }

    public String getVersion() {
        if (this.version == null) {
            try {
                this.version = Objects.getVersion(JmxTreeWatcher.class, "io.hawt", "hawtio-web");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.version == null) {
                this.version = "";
            }
        }
        return this.version;
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=TreeWatcher");
    }

    protected NotificationListener getNotificationListener() {
        return (notification, handback) -> this.counter.incrementAndGet();
    }

    protected NotificationFilter getNotificationFilter() {
        return new NotificationFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return true;
            }
        };
    }

    @Override
    public long getCounter() {
        return this.counter.get();
    }
}

