// This file is auto-generated by @hey-api/openapi-ts

/**
 * Schema for telling task which bundle to run with.
 */
export type BundleInfo = {
    name: string;
    version?: string | null;
};

/**
 * Job that is to be executed on the edge worker.
 */
export type EdgeJobFetched = {
    /**
     * Identifier of the DAG to which the task belongs.
     */
    dag_id: string;
    /**
     * Task name in the DAG.
     */
    task_id: string;
    /**
     * Run ID of the DAG execution.
     */
    run_id: string;
    /**
     * For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     */
    map_index: number;
    /**
     * The number of attempt to execute this task.
     */
    try_number: number;
    /**
     * Command line to use to execute the job in Airflow 2. Task definition in Airflow 3
     */
    command: ExecuteTask;
    /**
     * Number of concurrency slots the job requires.
     */
    concurrency_slots: number;
};

/**
 * Status of a Edge Worker instance.
 */
export type EdgeWorkerState = 'starting' | 'running' | 'idle' | 'shutdown request' | 'terminating' | 'offline' | 'unknown' | 'maintenance request' | 'maintenance pending' | 'maintenance mode' | 'maintenance exit' | 'offline maintenance';

/**
 * Execute the given Task.
 */
export type ExecuteTask = {
    token: string;
    ti: TaskInstance;
    dag_rel_path: string;
    bundle_info: BundleInfo;
    log_path: string | null;
    type?: "ExecuteTask";
};

/**
 * HTTPException Model used for error response.
 */
export type HTTPExceptionResponse = {
    detail: string | {
    [key: string]: unknown;
};
};

export type HTTPValidationError = {
    detail?: Array<ValidationError>;
};

/**
 * Details of the job sent to the scheduler.
 */
export type Job = {
    /**
     * Identifier of the DAG to which the task belongs.
     */
    dag_id: string;
    /**
     * Task name in the DAG.
     */
    task_id: string;
    /**
     * Run ID of the DAG execution.
     */
    run_id: string;
    /**
     * For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     */
    map_index: number;
    /**
     * The number of attempt to execute this task.
     */
    try_number: number;
    /**
     * State of the job from the view of the executor.
     */
    state: TaskInstanceState;
    /**
     * Queue for which the task is scheduled/running.
     */
    queue: string;
    /**
     * When the job was queued.
     */
    queued_dttm?: string | null;
    /**
     * The worker processing the job during execution.
     */
    edge_worker?: string | null;
    /**
     * Last heartbeat of the job.
     */
    last_update?: string | null;
};

/**
 * Job Collection serializer.
 */
export type JobCollectionResponse = {
    jobs: Array<Job>;
    total_entries: number;
};

/**
 * Request body for maintenance operations.
 */
export type MaintenanceRequest = {
    /**
     * Comment describing the maintenance reason.
     */
    maintenance_comment: string;
};

/**
 * Incremental new log content from worker.
 */
export type PushLogsBody = {
    /**
     * Time of the log chunk at point of sending.
     */
    log_chunk_time: string;
    /**
     * Log chunk data as incremental log text.
     */
    log_chunk_data: string;
};

/**
 * Schema for TaskInstance with minimal required fields needed for Executors and Task SDK.
 */
export type TaskInstance = {
    id: string;
    dag_version_id: string;
    task_id: string;
    dag_id: string;
    run_id: string;
    try_number: number;
    map_index?: number;
    pool_slots: number;
    queue: string;
    priority_weight: number;
    parent_context_carrier?: {
    [key: string]: unknown;
} | null;
    context_carrier?: {
    [key: string]: unknown;
} | null;
};

/**
 * All possible states that a Task Instance can be in.
 *
 * Note that None is also allowed, so always use this in a type hint with Optional.
 */
export type TaskInstanceState = 'removed' | 'scheduled' | 'queued' | 'running' | 'success' | 'restarting' | 'failed' | 'up_for_retry' | 'up_for_reschedule' | 'upstream_failed' | 'skipped' | 'deferred';

export type ValidationError = {
    loc: Array<(string | number)>;
    msg: string;
    type: string;
};

/**
 * Details of the worker state sent to the scheduler.
 */
export type Worker = {
    /**
     * List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.
     */
    queues?: Array<(string)> | null;
    /**
     * State of the worker from the view of the worker.
     */
    state: EdgeWorkerState;
    /**
     * Number of active jobs the worker is running.
     */
    jobs_active?: number;
    /**
     * System information of the worker.
     */
    sysinfo: {
        [key: string]: (string | number);
    };
    /**
     * Comments about the maintenance state of the worker.
     */
    maintenance_comments?: string | null;
    /**
     * Name of the worker.
     */
    worker_name: string;
    /**
     * When the worker was first online.
     */
    first_online?: string | null;
    /**
     * When the worker last sent a heartbeat.
     */
    last_heartbeat?: string | null;
};

/**
 * Worker Collection serializer.
 */
export type WorkerCollectionResponse = {
    workers: Array<Worker>;
    total_entries: number;
};

/**
 * Changed queues for the worker.
 */
export type WorkerQueueUpdateBody = {
    /**
     * Additional queues to be added to worker.
     */
    new_queues: Array<(string)> | null;
    /**
     * Queues to remove from worker.
     */
    remove_queues: Array<(string)> | null;
};

/**
 * Queues that a worker supports to run jobs on.
 */
export type WorkerQueuesBody = {
    /**
     * List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.
     */
    queues?: Array<(string)> | null;
    /**
     * Number of free concurrency slots on the worker.
     */
    free_concurrency: number;
};

/**
 * The return class for the worker registration.
 */
export type WorkerRegistrationReturn = {
    /**
     * Time of the last update of the worker.
     */
    last_update: string;
};

/**
 * The return class for the worker set state.
 */
export type WorkerSetStateReturn = {
    /**
     * State of the worker from the view of the server.
     */
    state: EdgeWorkerState;
    /**
     * List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.
     */
    queues: Array<(string)> | null;
    /**
     * Comments about the maintenance state of the worker.
     */
    maintenance_comments?: string | null;
};

/**
 * Details of the worker state sent to the scheduler.
 */
export type WorkerStateBody = {
    /**
     * List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.
     */
    queues?: Array<(string)> | null;
    /**
     * State of the worker from the view of the worker.
     */
    state: EdgeWorkerState;
    /**
     * Number of active jobs the worker is running.
     */
    jobs_active?: number;
    /**
     * System information of the worker.
     */
    sysinfo: {
        [key: string]: (string | number);
    };
    /**
     * Comments about the maintenance state of the worker.
     */
    maintenance_comments?: string | null;
};

export type FetchData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    requestBody: WorkerQueuesBody;
    workerName: string;
};

export type FetchResponse = EdgeJobFetched | null;

export type StateData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    /**
     * Identifier of the DAG to which the task belongs.
     */
    dagId: string;
    /**
     * For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     */
    mapIndex: number;
    /**
     * Run ID of the DAG execution.
     */
    runId: string;
    /**
     * State of the assigned task under execution.
     */
    state: TaskInstanceState;
    /**
     * Task name in the DAG.
     */
    taskId: string;
    /**
     * The number of attempt to execute this task.
     */
    tryNumber: number;
};

export type StateResponse = unknown;

export type LogfilePathData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    /**
     * Identifier of the DAG to which the task belongs.
     */
    dagId: string;
    /**
     * For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     */
    mapIndex: number;
    /**
     * Run ID of the DAG execution.
     */
    runId: string;
    /**
     * Task name in the DAG.
     */
    taskId: string;
    /**
     * The number of attempt to execute this task.
     */
    tryNumber: number;
};

export type LogfilePathResponse = string;

export type PushLogsData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    /**
     * Identifier of the DAG to which the task belongs.
     */
    dagId: string;
    /**
     * For dynamically mapped tasks the mapping number, -1 if the task is not mapped.
     */
    mapIndex: number;
    requestBody: PushLogsBody;
    /**
     * Run ID of the DAG execution.
     */
    runId: string;
    /**
     * Task name in the DAG.
     */
    taskId: string;
    /**
     * The number of attempt to execute this task.
     */
    tryNumber: number;
};

export type PushLogsResponse = unknown;

export type RegisterData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    requestBody: WorkerStateBody;
    /**
     * Hostname or instance name of the worker
     */
    workerName: string;
};

export type RegisterResponse = WorkerRegistrationReturn;

export type SetStateData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    requestBody: WorkerStateBody;
    /**
     * Hostname or instance name of the worker
     */
    workerName: string;
};

export type SetStateResponse = WorkerSetStateReturn;

export type UpdateQueuesData = {
    /**
     * JWT Authorization Token
     */
    authorization: string;
    requestBody: WorkerQueueUpdateBody;
    /**
     * Hostname or instance name of the worker
     */
    workerName: string;
};

export type UpdateQueuesResponse = unknown;

export type HealthResponse = {
    [key: string]: (string);
};

export type WorkerResponse = WorkerCollectionResponse;

export type JobsResponse = JobCollectionResponse;

export type RequestWorkerMaintenanceData = {
    requestBody: MaintenanceRequest;
    workerName: string;
};

export type RequestWorkerMaintenanceResponse = unknown;

export type ExitWorkerMaintenanceData = {
    workerName: string;
};

export type ExitWorkerMaintenanceResponse = unknown;

export type $OpenApiTs = {
    '/edge_worker/v1/jobs/fetch/{worker_name}': {
        post: {
            req: FetchData;
            res: {
                /**
                 * Successful Response
                 */
                200: EdgeJobFetched | null;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
    '/edge_worker/v1/jobs/state/{dag_id}/{task_id}/{run_id}/{try_number}/{map_index}/{state}': {
        patch: {
            req: StateData;
            res: {
                /**
                 * Successful Response
                 */
                200: unknown;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
    '/edge_worker/v1/logs/logfile_path/{dag_id}/{task_id}/{run_id}/{try_number}/{map_index}': {
        get: {
            req: LogfilePathData;
            res: {
                /**
                 * Successful Response
                 */
                200: string;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
    '/edge_worker/v1/logs/push/{dag_id}/{task_id}/{run_id}/{try_number}/{map_index}': {
        post: {
            req: PushLogsData;
            res: {
                /**
                 * Successful Response
                 */
                200: unknown;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
    '/edge_worker/v1/worker/{worker_name}': {
        post: {
            req: RegisterData;
            res: {
                /**
                 * Successful Response
                 */
                200: WorkerRegistrationReturn;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
        patch: {
            req: SetStateData;
            res: {
                /**
                 * Successful Response
                 */
                200: WorkerSetStateReturn;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
    '/edge_worker/v1/worker/queues/{worker_name}': {
        patch: {
            req: UpdateQueuesData;
            res: {
                /**
                 * Successful Response
                 */
                200: unknown;
                /**
                 * Bad Request
                 */
                400: HTTPExceptionResponse;
                /**
                 * Forbidden
                 */
                403: HTTPExceptionResponse;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
    '/edge_worker/v1/health': {
        get: {
            res: {
                /**
                 * Successful Response
                 */
                200: {
                    [key: string]: (string);
                };
            };
        };
    };
    '/edge_worker/ui/worker': {
        get: {
            res: {
                /**
                 * Successful Response
                 */
                200: WorkerCollectionResponse;
            };
        };
    };
    '/edge_worker/ui/jobs': {
        get: {
            res: {
                /**
                 * Successful Response
                 */
                200: JobCollectionResponse;
            };
        };
    };
    '/edge_worker/ui/worker/{worker_name}/maintenance': {
        post: {
            req: RequestWorkerMaintenanceData;
            res: {
                /**
                 * Successful Response
                 */
                200: unknown;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
        delete: {
            req: ExitWorkerMaintenanceData;
            res: {
                /**
                 * Successful Response
                 */
                200: unknown;
                /**
                 * Validation Error
                 */
                422: HTTPValidationError;
            };
        };
    };
};