/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class AlterViewStatement
extends AlterSchemaStatement {
    private final String viewName;
    private final TableAttributes attrs;
    private ClientState state;
    private final boolean ifExists;

    public AlterViewStatement(String keyspaceName, String viewName, TableAttributes attrs, boolean ifExists) {
        super(keyspaceName);
        this.viewName = viewName;
        this.attrs = attrs;
        this.ifExists = ifExists;
    }

    @Override
    public void validate(ClientState state) {
        super.validate(state);
        this.state = state;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        ViewMetadata view;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        ViewMetadata viewMetadata = view = null == keyspace ? null : keyspace.views.getNullable(this.viewName);
        if (null == view) {
            if (this.ifExists) {
                return schema;
            }
            throw AlterViewStatement.ire("Materialized view '%s.%s' doesn't exist", this.keyspaceName, this.viewName);
        }
        this.attrs.validate();
        Guardrails.tableProperties.guard(this.attrs.updatedProperties(), this.attrs::removeProperty, this.state);
        TableParams params = this.attrs.asAlteredTableParams(view.metadata.params);
        if (params.gcGraceSeconds == 0) {
            throw AlterViewStatement.ire("Cannot alter gc_grace_seconds of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.", new Object[0]);
        }
        if (params.defaultTimeToLive > 0) {
            throw AlterViewStatement.ire("Forbidden default_time_to_live detected for a materialized view. Data in a materialized view always expire at the same time than the corresponding data in the parent table. default_time_to_live must be set to zero, see CASSANDRA-12868 for more information", new Object[0]);
        }
        ViewMetadata newView = view.copy(view.metadata.withSwapped(params));
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.views.withSwapped(newView)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.viewName);
    }

    @Override
    public void authorize(ClientState client) {
        ViewMetadata view = Schema.instance.getView(this.keyspaceName, this.viewName);
        if (null != view) {
            client.ensureTablePermission(this.keyspaceName, view.baseTableName, Permission.ALTER);
        }
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.ALTER_VIEW, this.keyspaceName, this.viewName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.viewName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final TableAttributes attrs;
        private final boolean ifExists;

        public Raw(QualifiedName name, TableAttributes attrs, boolean ifExists) {
            this.name = name;
            this.attrs = attrs;
            this.ifExists = ifExists;
        }

        @Override
        public AlterViewStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            return new AlterViewStatement(keyspaceName, this.name.getName(), this.attrs, this.ifExists);
        }
    }
}

