/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SingletonIndexQueryPlan;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.schema.TableMetadata;

public class SingletonIndexGroup
implements Index.Group {
    private final Index delegate;
    private final Set<Index> indexes;

    protected SingletonIndexGroup(Index delegate) {
        this.delegate = delegate;
        this.indexes = Collections.singleton(delegate);
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    public Index getIndex() {
        return this.delegate;
    }

    @Override
    public boolean containsIndex(Index index) {
        return index.equals(this.delegate);
    }

    @Override
    public Index.Indexer indexerFor(Predicate<Index> indexSelector, DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, WriteContext ctx, IndexTransaction.Type transactionType, Memtable memtable) {
        return indexSelector.test(this.delegate) ? this.delegate.indexerFor(key, columns, nowInSec, ctx, transactionType, memtable) : null;
    }

    @Override
    public Index.QueryPlan queryPlanFor(RowFilter rowFilter) {
        return SingletonIndexQueryPlan.create(this.delegate, rowFilter);
    }

    @Override
    public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker, TableMetadata tableMetadata) {
        return this.delegate.getFlushObserver(descriptor, tracker);
    }

    @Override
    public Set<Component> getComponents() {
        return this.delegate.getComponents();
    }
}

