/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterComponent {
    private static final Logger logger = LoggerFactory.getLogger(FilterComponent.class);
    static final boolean rebuildFilterOnFPChanceChange = false;
    static final double filterFPChanceTolerance = 0.0;

    private FilterComponent() {
    }

    public static IFilter load(Descriptor descriptor) throws IOException {
        BloomFilter bloomFilter;
        block10: {
            File filterFile = descriptor.fileFor(SSTableFormat.Components.FILTER);
            if (!filterFile.exists()) {
                return null;
            }
            if (filterFile.length() == 0L) {
                return FilterFactory.AlwaysPresent;
            }
            FileInputStreamPlus stream = descriptor.fileFor(SSTableFormat.Components.FILTER).newInputStream();
            try {
                bloomFilter = BloomFilterSerializer.forVersion(descriptor.version.hasOldBfFormat()).deserialize(stream);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IOException("Failed to load Bloom filter for SSTable: " + descriptor.baseFile(), ex);
                }
            }
            stream.close();
        }
        return bloomFilter;
    }

    public static void save(IFilter filter, Descriptor descriptor, boolean deleteOnFailure) throws IOException {
        File filterFile = descriptor.fileFor(SSTableFormat.Components.FILTER);
        try (FileOutputStreamPlus stream = filterFile.newOutputStream(File.WriteMode.OVERWRITE);){
            filter.serialize(stream, descriptor.version.hasOldBfFormat());
            stream.flush();
            stream.sync();
        }
        catch (IOException ex) {
            if (deleteOnFailure) {
                descriptor.fileFor(SSTableFormat.Components.FILTER).deleteIfExists();
            }
            throw new IOException("Failed to save Bloom filter for SSTable: " + descriptor.baseFile(), ex);
        }
    }

    public static IFilter maybeLoadBloomFilter(Descriptor descriptor, Set<Component> components, TableMetadata metadata, ValidationMetadata validationMetadata) {
        double currentFPChance = validationMetadata != null ? validationMetadata.bloomFilterFPChance : Double.NaN;
        double desiredFPChance = metadata.params.bloomFilterFpChance;
        IFilter filter = null;
        if (!FilterComponent.shouldUseBloomFilter(desiredFPChance)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Bloom filter for {} will not be loaded because fpChance={} is negligible", (Object)descriptor, (Object)desiredFPChance);
            }
            return FilterFactory.AlwaysPresent;
        }
        if (!components.contains(SSTableFormat.Components.FILTER) || Double.isNaN(currentFPChance)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Bloom filter for {} will not be loaded because the filter component is missing or sstable lacks validation metadata", (Object)descriptor);
            }
            return null;
        }
        if (!FilterComponent.isFPChanceDiffNegligible(desiredFPChance, currentFPChance)) {
            // empty if block
        }
        try {
            filter = FilterComponent.load(descriptor);
            if (filter == null || !filter.isInformative()) {
                logger.info("Bloom filter for {} is missing or invalid", (Object)descriptor);
            }
        }
        catch (IOException ex) {
            logger.info("Bloom filter for " + descriptor + " could not be deserialized", (Throwable)ex);
        }
        return filter;
    }

    static boolean shouldUseBloomFilter(double fpChance) {
        return !(Math.abs(1.0 - fpChance) <= 0.0);
    }

    static boolean isFPChanceDiffNegligible(double fpChance1, double fpChance2) {
        return Math.abs(fpChance1 - fpChance2) <= 0.0;
    }
}

