/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributePanel;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityRelationshipPanel;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityTab;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.DbAttributeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DbRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;

public class DbEntityTabbedView
extends JTabbedPane
implements ChangeListener,
DbEntityDisplayListener,
DbRelationshipDisplayListener,
DbAttributeDisplayListener {
    protected ProjectController projectController;
    protected Component entityPanel;
    protected DbEntityAttributeRelationshipTab attributeRelationshipTab;

    public DbEntityTabbedView(ProjectController projectController) {
        this.projectController = projectController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.entityPanel = new JScrollPane(new DbEntityTab(this.projectController));
        this.addTab("Entity", this.entityPanel);
        this.attributeRelationshipTab = new DbEntityAttributeRelationshipTab(this.projectController);
        this.addTab("Properties", this.attributeRelationshipTab);
    }

    private void initController() {
        this.projectController.addDbEntityDisplayListener(this);
        this.projectController.addDbAttributeDisplayListener(this);
        this.projectController.addDbRelationshipDisplayListener(this);
        this.addChangeListener(this);
    }

    private void resetRemoveButtons() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        actionManager.getAction(RemoveAttributeAction.class).setEnabled(false);
        actionManager.getAction(RemoveRelationshipAction.class).setEnabled(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.resetRemoveButtons();
        this.projectController.setEntityTabSelection(this.getSelectedIndex());
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        Entity entity = e.getEntity();
        if (e.isMainTabFocus() && entity instanceof DbEntity && this.getSelectedComponent() != this.entityPanel) {
            this.setSelectedComponent(this.entityPanel);
            this.entityPanel.setVisible(true);
        }
        this.resetRemoveButtons();
        this.setVisible(e.getEntity() != null);
        if (this.projectController.getEntityTabSelection() < this.getTabCount()) {
            this.setSelectedIndex(this.projectController.getEntityTabSelection());
        }
    }

    @Override
    public void currentDbRelationshipChanged(RelationshipDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Relationship[] rels = e.getRelationships();
        Object[] dbRels = new DbRelationship[rels.length];
        System.arraycopy(rels, 0, dbRels, 0, rels.length);
        if (this.getSelectedComponent() != this.attributeRelationshipTab.getSplitPane().getComponent(1) && dbRels.length > 0) {
            this.setSelectedComponent(this.attributeRelationshipTab);
            this.attributeRelationshipTab.getSplitPane().getComponent(1).setVisible(true);
        }
        ((DbEntityRelationshipPanel)this.attributeRelationshipTab.getSplitPane().getComponent(1)).selectRelationships((DbRelationship[])dbRels);
        this.attributeRelationshipTab.updateActions(dbRels);
    }

    @Override
    public void currentDbAttributeChanged(AttributeDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Attribute[] attrs = e.getAttributes();
        Object[] dbAttrs = new DbAttribute[attrs.length];
        System.arraycopy(attrs, 0, dbAttrs, 0, attrs.length);
        if (this.getSelectedComponent() != this.attributeRelationshipTab.getSplitPane().getComponent(0) && dbAttrs.length > 0) {
            this.setSelectedComponent(this.attributeRelationshipTab);
            this.attributeRelationshipTab.getSplitPane().getComponent(0).setVisible(true);
        }
        ((DbEntityAttributePanel)this.attributeRelationshipTab.getSplitPane().getComponent(0)).selectAttributes((DbAttribute[])dbAttrs);
        this.attributeRelationshipTab.updateActions(dbAttrs);
    }

    public DbEntityAttributeRelationshipTab getAttributeRelationshipTab() {
        return this.attributeRelationshipTab;
    }
}

