/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.annotations.handlers;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import org.apache.commons.digester3.annotations.AnnotationHandler;
import org.apache.commons.digester3.annotations.rules.ObjectCreate;
import org.apache.commons.digester3.binder.ObjectCreateBuilder;
import org.apache.commons.digester3.binder.RulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectCreateHandler
implements AnnotationHandler<ObjectCreate, AnnotatedElement> {
    @Override
    public void handle(ObjectCreate annotation, AnnotatedElement element, RulesBinder rulesBinder) {
        Class type = null;
        if (element instanceof Class) {
            type = (Class)element;
        } else if (element instanceof Constructor) {
            type = ((Constructor)element).getDeclaringClass();
        } else {
            rulesBinder.addError("Misplaced @ObjectCreate annotation to %s, Class and Constructor only supported", element);
            return;
        }
        ObjectCreateBuilder builder = rulesBinder.forPattern(annotation.pattern()).withNamespaceURI(annotation.namespaceURI()).createObject().ofType(type).ofTypeSpecifiedByAttribute(annotation.attributeName() != null ? annotation.attributeName() : null);
        if (element instanceof Constructor) {
            Constructor method = (Constructor)element;
            builder.usingConstructor(method.getParameterTypes());
        }
    }
}

