/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.UnknownLicense;
import org.apache.rat.analysis.matchers.FullTextMatcher;
import org.apache.rat.api.Document;
import org.apache.rat.license.ILicense;

public class HeaderCheckWorker {
    public static final int DEFAULT_NUMBER_OF_RETAINED_HEADER_LINES = 50;
    private final int numberOfRetainedHeaderLines;
    private final BufferedReader reader;
    private final Collection<ILicense> licenses;
    private final Document document;
    private final IHeaderMatcher generatedMatcher;

    public static IHeaders readHeader(BufferedReader reader, int numberOfLines) throws IOException {
        String line;
        StringBuilder headers = new StringBuilder();
        int headerLinesRead = 0;
        while (headerLinesRead < numberOfLines && (line = reader.readLine()) != null) {
            headers.append(line).append(System.lineSeparator());
        }
        final String raw = headers.toString();
        final String pruned = FullTextMatcher.prune(raw).toLowerCase(Locale.ENGLISH);
        return new IHeaders(){

            @Override
            public String raw() {
                return raw;
            }

            @Override
            public String pruned() {
                return pruned;
            }

            public String toString() {
                return this.getClass().getSimpleName();
            }
        };
    }

    public HeaderCheckWorker(IHeaderMatcher generatedMatcher, Reader reader, Collection<ILicense> licenses, Document name) {
        this(generatedMatcher, reader, 50, licenses, name);
    }

    public HeaderCheckWorker(IHeaderMatcher generatedMatcher, Reader reader, int numberOfRetainedHeaderLine, Collection<ILicense> licenses, Document document) {
        Objects.requireNonNull(reader, "Reader may not be null");
        Objects.requireNonNull(licenses, "Licenses may not be null");
        if (numberOfRetainedHeaderLine < 0) {
            throw new ConfigurationException("numberOfRetainedHeaderLine may not be less than zero");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.numberOfRetainedHeaderLines = numberOfRetainedHeaderLine;
        this.licenses = licenses;
        this.document = document;
        this.generatedMatcher = generatedMatcher;
    }

    public void read() throws RatHeaderAnalysisException {
        try {
            IHeaders headers = HeaderCheckWorker.readHeader(this.reader, this.numberOfRetainedHeaderLines);
            if (this.generatedMatcher.matches(headers)) {
                this.document.getMetaData().setDocumentType(Document.Type.IGNORED);
            } else {
                this.licenses.stream().filter(lic -> lic.matches(headers)).forEach(this.document.getMetaData()::reportOnLicense);
                if (!this.document.getMetaData().detectedLicense()) {
                    this.document.getMetaData().reportOnLicense(UnknownLicense.INSTANCE);
                }
            }
        }
        catch (IOException e) {
            throw new RatHeaderAnalysisException("Cannot read header for " + this.document, e);
        }
        finally {
            this.licenses.forEach(IHeaderMatcher::reset);
        }
    }
}

