/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.NothingWrittenException;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.codec.AbstractProtocolDecoderOutput;
import org.apache.mina.filter.codec.AbstractProtocolEncoderOutput;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.RecoverableProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolCodecFilter.class);
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final IoBuffer EMPTY_BUFFER = IoBuffer.wrap(new byte[0]);
    private static final AttributeKey ENCODER = new AttributeKey(ProtocolCodecFilter.class, "encoder");
    private static final AttributeKey DECODER = new AttributeKey(ProtocolCodecFilter.class, "decoder");
    private static final AttributeKey DECODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "decoderOut");
    private static final AttributeKey ENCODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "encoderOut");
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        this.factory = factory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder encoder, final ProtocolDecoder decoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder");
        }
        if (decoder == null) {
            throw new IllegalArgumentException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) {
                return decoder;
            }
        };
    }

    public ProtocolCodecFilter(Class<? extends ProtocolEncoder> encoderClass, Class<? extends ProtocolDecoder> decoderClass) {
        ProtocolDecoder decoder;
        ProtocolEncoder encoder;
        if (encoderClass == null) {
            throw new IllegalArgumentException("encoderClass");
        }
        if (decoderClass == null) {
            throw new IllegalArgumentException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("encoderClass: " + encoderClass.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("decoderClass: " + decoderClass.getName());
        }
        try {
            encoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            decoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        try {
            encoder = encoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("encoderClass cannot be initialized");
        }
        try {
            decoder = decoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("decoderClass cannot be initialized");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return decoder;
            }
        };
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return (ProtocolEncoder)session.getAttribute(ENCODER);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeCodec(parent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing a MESSAGE_RECEIVED for session {}", (Object)session.getId());
        }
        if (!(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer in = (IoBuffer)message;
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        while (in.hasRemaining()) {
            int oldPos = in.position();
            try {
                IoSession ioSession = session;
                synchronized (ioSession) {
                    decoder.decode(session, in, decoderOut);
                }
                decoderOut.flush(nextFilter, session);
            }
            catch (Exception e) {
                ProtocolDecoderException pde = e instanceof ProtocolDecoderException ? (ProtocolDecoderException)e : new ProtocolDecoderException(e);
                if (pde.getHexdump() == null) {
                    int curPos = in.position();
                    in.position(oldPos);
                    pde.setHexdump(in.getHexDump());
                    in.position(curPos);
                }
                decoderOut.flush(nextFilter, session);
                nextFilter.exceptionCaught(session, pde);
                if (e instanceof RecoverableProtocolDecoderException && in.position() != oldPos) continue;
                break;
            }
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest instanceof EncodedWriteRequest) {
            return;
        }
        nextFilter.messageSent(session, writeRequest);
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof IoBuffer || message instanceof FileRegion) {
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        ProtocolEncoder encoder = this.factory.getEncoder(session);
        ProtocolEncoderOutput encoderOut = this.getEncoderOut(session, nextFilter, writeRequest);
        if (encoder == null) {
            throw new ProtocolEncoderException("The encoder is null for the session " + session);
        }
        try {
            Object encodedMessage;
            encoder.encode(session, message, encoderOut);
            Queue<Object> bufferQueue = ((AbstractProtocolEncoderOutput)encoderOut).getMessageQueue();
            while (!bufferQueue.isEmpty() && (encodedMessage = bufferQueue.poll()) != null) {
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                if (bufferQueue.isEmpty()) {
                    writeRequest.setMessage(encodedMessage);
                    nextFilter.filterWrite(session, writeRequest);
                    continue;
                }
                SocketAddress destination = writeRequest.getDestination();
                EncodedWriteRequest encodedWriteRequest = new EncodedWriteRequest(encodedMessage, null, destination);
                nextFilter.filterWrite(session, encodedWriteRequest);
            }
        }
        catch (Exception e) {
            ProtocolEncoderException pee = e instanceof ProtocolEncoderException ? (ProtocolEncoderException)e : new ProtocolEncoderException(e);
            throw pee;
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        try {
            decoder.finishDecode(session, decoderOut);
        }
        catch (Exception e) {
            ProtocolDecoderException pde = e instanceof ProtocolDecoderException ? (ProtocolDecoderException)e : new ProtocolDecoderException(e);
            throw pde;
        }
        finally {
            this.disposeCodec(session);
            decoderOut.flush(nextFilter, session);
        }
        nextFilter.sessionClosed(session);
    }

    private void disposeCodec(IoSession session) {
        this.disposeEncoder(session);
        this.disposeDecoder(session);
        this.disposeDecoderOut(session);
    }

    private void disposeEncoder(IoSession session) {
        ProtocolEncoder encoder = (ProtocolEncoder)session.removeAttribute(ENCODER);
        if (encoder == null) {
            return;
        }
        try {
            encoder.dispose(session);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to dispose: " + encoder.getClass().getName() + " (" + encoder + ')');
        }
    }

    private void disposeDecoder(IoSession session) {
        ProtocolDecoder decoder = (ProtocolDecoder)session.removeAttribute(DECODER);
        if (decoder == null) {
            return;
        }
        try {
            decoder.dispose(session);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to dispose: " + decoder.getClass().getName() + " (" + decoder + ')');
        }
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession session, IoFilter.NextFilter nextFilter) {
        ProtocolDecoderOutput out = (ProtocolDecoderOutput)session.getAttribute(DECODER_OUT);
        if (out == null) {
            out = new ProtocolDecoderOutputImpl();
            session.setAttribute(DECODER_OUT, out);
        }
        return out;
    }

    private ProtocolEncoderOutput getEncoderOut(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        ProtocolEncoderOutput out = (ProtocolEncoderOutput)session.getAttribute(ENCODER_OUT);
        if (out == null) {
            out = new ProtocolEncoderOutputImpl(session, nextFilter, writeRequest);
            session.setAttribute(ENCODER_OUT, out);
        }
        return out;
    }

    private void disposeDecoderOut(IoSession session) {
        session.removeAttribute(DECODER_OUT);
    }

    private static class ProtocolEncoderOutputImpl
    extends AbstractProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final SocketAddress destination;

        public ProtocolEncoderOutputImpl(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
            this.session = session;
            this.nextFilter = nextFilter;
            this.destination = writeRequest.getDestination();
        }

        @Override
        public WriteFuture flush() {
            Object encodedMessage;
            Queue<Object> bufferQueue = this.getMessageQueue();
            WriteFuture future = null;
            while (!bufferQueue.isEmpty() && (encodedMessage = bufferQueue.poll()) != null) {
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                future = new DefaultWriteFuture(this.session);
                this.nextFilter.filterWrite(this.session, new EncodedWriteRequest(encodedMessage, future, this.destination));
            }
            if (future == null) {
                future = DefaultWriteFuture.newNotWrittenFuture(this.session, new NothingWrittenException(AbstractIoSession.MESSAGE_SENT_REQUEST));
            }
            return future;
        }
    }

    private static class ProtocolDecoderOutputImpl
    extends AbstractProtocolDecoderOutput {
        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            Queue<Object> messageQueue = this.getMessageQueue();
            while (!messageQueue.isEmpty()) {
                nextFilter.messageReceived(session, messageQueue.poll());
            }
        }
    }

    private static class EncodedWriteRequest
    extends DefaultWriteRequest {
        public EncodedWriteRequest(Object encodedMessage, WriteFuture future, SocketAddress destination) {
            super(encodedMessage, future, destination);
        }

        @Override
        public boolean isEncoded() {
            return true;
        }
    }
}

