/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.http.AddressType;

@NoJSR250Annotations
public class LocalTransportFactory
extends AbstractTransportFactory
implements DestinationFactory,
ConduitInitiator {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/local";
    public static final List<String> DEFAULT_NAMESPACES = Collections.singletonList("http://cxf.apache.org/transports/local");
    public static final String MESSAGE_FILTER_PROPERTIES = LocalTransportFactory.class.getName() + ".filterProperties";
    public static final String MESSAGE_INCLUDE_PROPERTIES = LocalTransportFactory.class.getName() + ".includeProperties";
    private static final Logger LOG = LogUtils.getL7dLogger(LocalTransportFactory.class);
    private static final Set<String> URI_PREFIXES = Collections.singleton("local://");
    private static final String NULL_ADDRESS = LocalTransportFactory.class.getName() + ".nulladdress";
    private ConcurrentMap<String, LocalDestination> destinations = new ConcurrentHashMap<String, LocalDestination>();
    private Set<String> messageFilterProperties = new HashSet<String>();
    private Set<String> messageIncludeProperties = new HashSet<String>();
    private Set<String> uriPrefixes = new HashSet<String>(URI_PREFIXES);
    private volatile Executor executor;

    public LocalTransportFactory() {
        super(DEFAULT_NAMESPACES);
        this.messageFilterProperties.add("org.apache.cxf.client");
        this.messageIncludeProperties.add(Message.PROTOCOL_HEADERS);
        this.messageIncludeProperties.add(Message.ENCODING);
        this.messageIncludeProperties.add("Content-Type");
        this.messageIncludeProperties.add("Accept");
        this.messageIncludeProperties.add(Message.RESPONSE_CODE);
        this.messageIncludeProperties.add("org.apache.cxf.request.uri");
        this.messageIncludeProperties.add(Message.ENDPOINT_ADDRESS);
        this.messageIncludeProperties.add("org.apache.cxf.request.method");
    }

    public LocalDestination getDestination(EndpointInfo ei, Bus bus) throws IOException {
        return this.getDestination(ei, LocalTransportFactory.createReference(ei), bus);
    }

    protected LocalDestination getDestination(EndpointInfo ei, EndpointReferenceType reference, Bus bus) throws IOException {
        LocalDestination tmpD;
        LocalDestination d;
        AddressType tp;
        String addr = reference.getAddress().getValue();
        if (addr == null && (tp = (AddressType)ei.getExtensor(AddressType.class)) != null) {
            addr = tp.getLocation();
        }
        if (addr == null) {
            addr = NULL_ADDRESS;
        }
        if ((d = (LocalDestination)((Object)this.destinations.get(addr))) == null && (tmpD = this.destinations.putIfAbsent(addr, d = this.createDestination(ei, reference, bus))) != null) {
            d = tmpD;
        }
        return d;
    }

    private LocalDestination createDestination(EndpointInfo ei, EndpointReferenceType reference, Bus bus) {
        LOG.info("Creating destination for address " + reference.getAddress().getValue());
        return new LocalDestination(this, reference, ei, bus);
    }

    void remove(LocalDestination destination) {
        this.destinations.values().remove((Object)destination);
    }

    public Executor getExecutor(Bus bus) {
        WorkQueueManager manager;
        if (this.executor == null && bus != null && (manager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class)) != null) {
            AutomaticWorkQueue ex = manager.getNamedWorkQueue("local-transport");
            if (ex == null) {
                ex = manager.getAutomaticWorkQueue();
            }
            return ex;
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Conduit getConduit(EndpointInfo ei, Bus bus) throws IOException {
        return new LocalConduit(this, this.getDestination(ei, bus));
    }

    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target, Bus bus) throws IOException {
        return new LocalConduit(this, this.getDestination(ei, target, bus));
    }

    private static EndpointReferenceType createReference(EndpointInfo ei) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(ei.getAddress());
        epr.setAddress(address);
        return epr;
    }

    public Set<String> getUriPrefixes() {
        return this.uriPrefixes;
    }

    public void setUriPrefixes(Set<String> s) {
        this.uriPrefixes = s;
    }

    public Set<String> getMessageFilterProperties() {
        return this.messageFilterProperties;
    }

    public void setMessageFilterProperties(Set<String> props) {
        this.messageFilterProperties = props;
    }

    public Set<String> getIncludeMessageProperties() {
        return this.messageIncludeProperties;
    }

    public void setMessageIncludeProperties(Set<String> props) {
        this.messageIncludeProperties = props;
    }

    public void copy(Message message, Message copy) {
        Set<String> includes;
        Set<String> filter = CastUtils.cast((Set)((Set)message.get((Object)MESSAGE_FILTER_PROPERTIES)));
        if (filter == null) {
            filter = this.messageFilterProperties;
        }
        if ((includes = CastUtils.cast((Set)((Set)message.get((Object)MESSAGE_INCLUDE_PROPERTIES)))) == null) {
            includes = this.messageIncludeProperties;
        }
        for (Map.Entry e : message.entrySet()) {
            if (!includes.contains(e.getKey()) && !this.messageIncludeProperties.contains(e.getKey()) || filter.contains(e.getKey())) continue;
            copy.put((Object)((String)e.getKey()), e.getValue());
        }
    }
}

