/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.cxf.ext.logging.MaskSensitiveHelper;
import org.apache.cxf.message.Message;

public class AttributeMaskingHelper
extends MaskSensitiveHelper {
    private static final String ATTR_NAME_TEMPLATE = "-ATTR_NAME-";
    private static final String PATTERN_XML_NAMESPACE_PREFIX = "[\\w.\\-\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]+";
    private static final String MATCH_PATTERN_XML_ATTR_TEMPLATE = "(\\b(?:[\\w.\\-\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]+:)?-ATTR_NAME-)\\s*=\\s*(\"|')(.*?)(\\2)";
    private static final String REPLACEMENT_XML_ATTR_TEMPLATE = "$1=$2XXX$4";
    private static final String XML_CONTENT = "xml";
    private static final String HTML_CONTENT = "html";
    private final Set<ReplacementPair> replacementsXMLAttributes = new HashSet<ReplacementPair>();

    public void addSensitiveAttributeNames(Set<String> inSensitiveAttirbuteNames) {
        if (inSensitiveAttirbuteNames == null || inSensitiveAttirbuteNames.isEmpty()) {
            return;
        }
        for (String attr : inSensitiveAttirbuteNames) {
            String match = MATCH_PATTERN_XML_ATTR_TEMPLATE.replace(ATTR_NAME_TEMPLATE, Pattern.quote(attr));
            String repl = REPLACEMENT_XML_ATTR_TEMPLATE.replace(ATTR_NAME_TEMPLATE, AttributeMaskingHelper.escapeForReplacement(attr));
            this.replacementsXMLAttributes.add(new ReplacementPair(match, repl));
        }
    }

    public void setSensitiveAttributeNames(Set<String> inSensitiveAttributeNames) {
        this.replacementsXMLAttributes.clear();
        this.addSensitiveAttributeNames(inSensitiveAttributeNames);
    }

    @Override
    public String maskSensitiveElements(Message message, String originalLogString) {
        String masked = super.maskSensitiveElements(message, originalLogString);
        if (masked == null || message == null) {
            return masked;
        }
        String contentType = (String)message.get((Object)"Content-Type");
        if (contentType == null) {
            return masked;
        }
        String lower = contentType.toLowerCase();
        if (lower.contains(XML_CONTENT) || lower.contains(HTML_CONTENT)) {
            return this.applyMasks(masked, this.replacementsXMLAttributes);
        }
        return masked;
    }

    private static String escapeForReplacement(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.replace("\\", "\\\\").replace("$", "\\$");
    }

    private String applyMasks(String input, Set<ReplacementPair> pairs) {
        String out = input;
        for (ReplacementPair rp : pairs) {
            out = rp.matchPattern.matcher(out).replaceAll(rp.replacement);
        }
        return out;
    }

    private static class ReplacementPair {
        private final Pattern matchPattern;
        private final String replacement;

        ReplacementPair(String matchPattern, String replacement) {
            this.matchPattern = Pattern.compile(matchPattern, 32);
            this.replacement = replacement;
        }
    }
}

