/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public final class JMSUtil {
    public static final String JMS_MESSAGE_CONSUMER = "jms_message_consumer";
    public static final String JMS_IGNORE_TIMEOUT = "jms_ignore_timeout";

    private JMSUtil() {
    }

    public static Message receive(Session session, Destination replyToDestination, String correlationId, long receiveTimeout, boolean pubSubNoLocal) {
        ResourceCloser closer = new ResourceCloser();
        try {
            String messageSelector = correlationId == null ? null : "JMSCorrelationID = '" + correlationId + "'";
            MessageConsumer consumer = closer.register(session.createConsumer(replyToDestination, messageSelector, pubSubNoLocal));
            Message replyMessage = consumer.receive(receiveTimeout);
            if (replyMessage == null) {
                throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
            }
            Message message = replyMessage;
            closer.close();
            return message;
        }
        catch (Throwable throwable) {
            try {
                try {
                    closer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JMSException e) {
                throw JMSUtil.convertJmsException(e);
            }
        }
    }

    public static Message receive(Session session, Destination replyToDestination, String correlationId, long receiveTimeout, boolean pubSubNoLocal, Exchange exchange) {
        ResourceCloser closer = new ResourceCloser();
        try {
            Message replyMessage;
            String messageSelector = correlationId == null ? null : "JMSCorrelationID = '" + correlationId + "'";
            MessageConsumer consumer = closer.register(session.createConsumer(replyToDestination, messageSelector, pubSubNoLocal));
            if (exchange != null) {
                exchange.put((Object)JMS_MESSAGE_CONSUMER, (Object)consumer);
            }
            if ((replyMessage = consumer.receive(receiveTimeout)) == null) {
                if (((Boolean)exchange.get((Object)JMS_IGNORE_TIMEOUT)).booleanValue()) {
                    throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                }
                throw new JMSException("Timeout receiving message with correlationId " + correlationId);
            }
            Message message = replyMessage;
            closer.close();
            return message;
        }
        catch (Throwable throwable) {
            try {
                try {
                    closer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JMSException e) {
                throw JMSUtil.convertJmsException(e);
            }
        }
    }

    public static RuntimeException convertJmsException(JMSException e) {
        return new RuntimeException(e.getMessage(), e);
    }

    public static String createCorrelationId(String prefix, long sequenceNum) {
        return prefix + StringUtils.toHexString((byte[])ByteBuffer.allocate(8).putLong(sequenceNum).array());
    }

    public static Message createAndSetPayload(Object payload, Session session, String messageType) throws JMSException {
        TextMessage message;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        return message;
    }

    public static Queue createQueue(Connection connection, String name) throws JMSException {
        if (connection instanceof XAConnection) {
            try (XASession session = ((XAConnection)connection).createXASession();){
                Queue queue = session.createQueue(name);
                return queue;
            }
        }
        try (Session session = connection.createSession(false, 1);){
            Queue queue = session.createQueue(name);
            return queue;
        }
    }
}

