/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jetty.ee11.servlet.ResourceServlet;
import org.eclipse.jetty.ee11.servlet.ServletApiRequest;
import org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.URIUtil;

public class ServletCoreRequest
implements Request {
    private final HttpServletRequest _servletRequest;
    private final ServletContextRequest _servletContextRequest;
    private final HttpFields _httpFields;
    private final HttpURI _uri;
    private final Attributes _attributes;
    private final boolean _wrapped;
    private Content.Source _source;

    public static Request wrap(HttpServletRequest httpServletRequest) {
        return new ServletCoreRequest(httpServletRequest, null);
    }

    ServletCoreRequest(HttpServletRequest request, Attributes attributes) {
        this._servletRequest = request;
        this._wrapped = !(request instanceof ServletApiRequest);
        this._servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)this._servletRequest);
        this._attributes = attributes == null ? this._servletContextRequest : attributes;
        HttpFields.Mutable fields = HttpFields.build((HttpFields)this._servletContextRequest.getHeaders());
        fields.clear();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                fields.add(new HttpField(headerName, headerValue));
            }
        }
        this._httpFields = fields.asImmutable();
        String includedServletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
        boolean included = includedServletPath != null;
        HttpURI.Mutable builder = HttpURI.build();
        builder.scheme(request.getScheme()).authority(request.getServerName(), request.getServerPort());
        if (included) {
            builder.path(URIUtil.addEncodedPaths((String)request.getContextPath(), (String)URIUtil.encodePath((String)ResourceServlet.getIncludedPathInContext(request, includedServletPath))));
        } else if (request.getDispatcherType() != DispatcherType.REQUEST) {
            builder.path(URIUtil.addEncodedPaths((String)request.getContextPath(), (String)URIUtil.encodePath((String)URIUtil.addPaths((String)this._servletRequest.getServletPath(), (String)this._servletRequest.getPathInfo()))));
        } else {
            builder.path(request.getRequestURI());
        }
        builder.query(request.getQueryString());
        this._uri = builder.asImmutable();
        this._source = this._wrapped ? null : this._servletContextRequest;
    }

    private Content.Source source() throws IOException {
        if (this._source == null) {
            this._source = this._wrapped ? new InputStreamContentSource((InputStream)this.getServletRequest().getInputStream()) : this._servletContextRequest;
        }
        return this._source;
    }

    public HttpFields getHeaders() {
        return this._httpFields;
    }

    public HttpURI getHttpURI() {
        return this._uri;
    }

    public String getId() {
        return this._servletRequest.getRequestId();
    }

    public String getMethod() {
        return this._servletRequest.getMethod();
    }

    public HttpServletRequest getServletRequest() {
        return this._servletRequest;
    }

    public boolean isSecure() {
        return this._servletRequest.isSecure();
    }

    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public void fail(Throwable failure) {
        try {
            this.source().fail(failure);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated((Throwable)failure, (Throwable)t);
        }
    }

    public Components getComponents() {
        return this._servletContextRequest.getComponents();
    }

    public ConnectionMetaData getConnectionMetaData() {
        return this._servletContextRequest.getConnectionMetaData();
    }

    public Context getContext() {
        return this._servletContextRequest.getContext();
    }

    public void demand(Runnable demandCallback) {
        try {
            this.source().demand(demandCallback);
        }
        catch (Throwable t) {
            demandCallback.run();
        }
    }

    public HttpFields getTrailers() {
        return this._servletContextRequest.getTrailers();
    }

    public long getBeginNanoTime() {
        return this._servletContextRequest.getBeginNanoTime();
    }

    public long getHeadersNanoTime() {
        return this._servletContextRequest.getHeadersNanoTime();
    }

    public Content.Chunk read() {
        try {
            return this.source().read();
        }
        catch (Throwable t) {
            return Content.Chunk.from((Throwable)t, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeAvailable() {
        if (this._wrapped) {
            ByteBufferPool byteBufferPool = this._servletContextRequest.getComponents().getByteBufferPool();
            RetainableByteBuffer.Mutable rbb = byteBufferPool.acquire(8192, false);
            try {
                ServletInputStream sis = this.getServletRequest().getInputStream();
                byte[] array = rbb.getByteBuffer().array();
                while (sis.isReady() && !sis.isFinished()) {
                    int read = sis.read(array);
                    if (read != -1) continue;
                    break;
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored exception while depleting wrapped ServletInputStream", x);
                }
            }
            finally {
                rbb.release();
            }
        }
        return this._servletContextRequest.consumeAvailable();
    }

    public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
        this._servletContextRequest.addIdleTimeoutListener(onIdleTimeout);
    }

    public void addFailureListener(Consumer<Throwable> onFailure) {
        this._servletContextRequest.addFailureListener(onFailure);
    }

    public TunnelSupport getTunnelSupport() {
        return this._servletContextRequest.getTunnelSupport();
    }

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
        this._servletContextRequest.addHttpStreamWrapper(wrapper);
    }

    public Session getSession(boolean create) {
        return Session.getSession((Object)this._servletRequest.getSession(create));
    }

    public static class ServletAttributes
    implements Attributes {
        private final HttpServletRequest _servletRequest;
        private Set<String> _attributeNames;

        public ServletAttributes(HttpServletRequest httpServletRequest) {
            this._servletRequest = httpServletRequest;
        }

        public Object removeAttribute(String name) {
            Object value = this._servletRequest.getAttribute(name);
            if (value != null) {
                this._attributeNames = null;
            }
            this._servletRequest.removeAttribute(name);
            return value;
        }

        public Object setAttribute(String name, Object attribute) {
            Object value = this._servletRequest.getAttribute(name);
            if (value == null) {
                this._attributeNames = null;
            }
            this._servletRequest.setAttribute(name, attribute);
            return value;
        }

        public Object getAttribute(String name) {
            return this._servletRequest.getAttribute(name);
        }

        public Set<String> getAttributeNameSet() {
            Set<String> set = this._attributeNames;
            if (set == null) {
                set = new HashSet<String>();
                Enumeration e = this._servletRequest.getAttributeNames();
                while (e.hasMoreElements()) {
                    set.add((String)e.nextElement());
                }
                this._attributeNames = set;
            }
            return set;
        }

        public void clearAttributes() {
            Enumeration e = this._servletRequest.getAttributeNames();
            this._attributeNames = null;
            while (e.hasMoreElements()) {
                this._servletRequest.removeAttribute((String)e.nextElement());
            }
        }
    }
}

