/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import org.mozilla.javascript.config.RhinoPropertiesLoader;

public class RhinoProperties {
    private static String[] CONFIG_FILES = new String[]{"rhino.config", "rhino-test.config"};
    private List<Map<?, ?>> configs = new ArrayList();
    private final boolean debug = Boolean.getBoolean("rhino.debugConfig");

    static RhinoProperties init() {
        RhinoProperties props = new RhinoProperties();
        Iterator<RhinoPropertiesLoader> loader = ServiceLoader.load(RhinoPropertiesLoader.class).iterator();
        if (loader.hasNext()) {
            while (loader.hasNext()) {
                RhinoPropertiesLoader next = loader.next();
                props.logDebug("Using loader %s", next.getClass().getName());
                next.load(props);
            }
        } else {
            props.logDebug("No loader found. Loading defaults", new Object[0]);
            props.loadDefaults();
        }
        return props;
    }

    public void loadDefaults() {
        ClassLoader classLoader = RhinoProperties.class.getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String configFile : CONFIG_FILES) {
            this.loadFromClasspath(classLoader, configFile);
            this.loadFromClasspath(contextClassLoader, configFile);
            this.loadFromFile(new File(configFile));
        }
        this.logDebug("loading configuration from System.getEnv()", new Object[0]);
        this.addConfig(System.getenv());
        this.logDebug("Rhino: loading configuration from System.getProperties()", new Object[0]);
        this.addConfig(System.getProperties());
    }

    public void loadFromFile(File config) {
        if (!config.exists()) {
            return;
        }
        this.logDebug("loading configuration from %s", config.getAbsoluteFile());
        try (FileInputStream in = new FileInputStream(config);){
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            this.addConfig(props);
        }
        catch (IOException e) {
            this.logError("Error loading configuration from %s: %s", config.getAbsoluteFile(), e.getMessage());
        }
    }

    public void loadFromClasspath(ClassLoader cl, String location) {
        if (cl != null) {
            this.loadFromResource(cl.getResource(location));
        }
    }

    public void loadFromResource(URL resource) {
        if (resource == null) {
            return;
        }
        this.logDebug("Rhino: loading configuration from %s", resource);
        try (InputStream in = resource.openStream();){
            Properties props = new Properties();
            props.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            this.addConfig(props);
        }
        catch (IOException e) {
            this.logError("Error loading configuration from %s: %s", resource, e.getMessage());
        }
    }

    public void addConfig(Map<?, ?> config) {
        this.logDebug("added %d values", config.size());
        this.configs.add(0, config);
    }

    public Object get(String property) {
        Objects.requireNonNull(property, "property must not be null");
        for (Map<?, ?> map : this.configs) {
            String key = property;
            for (int i = 0; i < 2; ++i) {
                Object ret = map.get(key);
                if (ret != null) {
                    this.logDebug("get(%s)=%s", key, ret);
                    return ret;
                }
                key = this.toCamelUpper(property);
            }
        }
        return null;
    }

    private String toCamelUpper(String property) {
        String s = property.replace('.', '_');
        StringBuilder sb = new StringBuilder(s.length() + 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i > 0 && Character.isUpperCase(c) && Character.isLowerCase(s.charAt(i - 1))) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    private void logDebug(String msg, Object ... args) {
        if (!this.debug) {
            return;
        }
        System.out.println("[Rhino] " + String.format(msg, args));
    }

    private void logError(String msg, Object ... args) {
        System.err.println("[Rhino] " + String.format(msg, args));
    }
}

