# GSoC Application Guidelines (2025)

## Introduction

Welcome to the Apache DataFusion Google Summer of Code (GSoC) application guidelines. We are excited to support contributors who are passionate about open-source data processing technologies and eager to contribute to DataFusion. This document provides detailed instructions on how to apply, what we expect from applicants, and how you can increase your chances of selection.

## Why Contribute to Apache DataFusion?

Apache DataFusion is a high-performance, extensible query engine for data processing, written in Rust and designed for modern analytical workloads. GSoC offers a fantastic opportunity for students and early-career developers to work with experienced mentors, learn about open-source development, and make meaningful contributions.

## Prerequisites

Before applying, ensure you:

- Have read and understood the [Apache DataFusion Contributor Guide](https://datafusion.apache.org/contributor-guide/index.html).
- Have basic familiarity with Rust programming and SQL-based data processing.
- Have explored DataFusion’s GitHub repository and tried running sample queries.
- Have introduced yourself on our mailing list or Discord to discuss project ideas with potential mentors.

## Application Process

To apply, follow these steps:

1. **Choose a Project Idea**
   - Review the list of proposed GSoC projects for Apache DataFusion.
   - If you have your own project idea, discuss it with potential mentors before submitting your proposal.
2. **Engage with the Community**
   - Join our [mailing list](mailto:dev@datafusion.apache.org) and [Discord](https://discord.gg/jHzkpK4em5) to introduce yourself and ask questions.
   - Optional: Submit a small pull request (PR) for an issue marked with the **good first issue** tag to understand/test whether you enjoy working on Apache DataFusion, get comfortable with navigating the codebase and demonstrate your ability.
3. **Write a Clear Proposal**
   - You can use the template below to structure your proposal.
   - Ensure it is has sufficient details and is feasible.
   - Seek feedback from mentors before submission.

## Application Template

```
# Apache DataFusion GSoC Application

## Personal Information

- **Name:**
- **GitHub ID:**
- **Email:**
- **LinkedIn/Personal Website (if any):**
- **Time Zone & Available Hours Per Week:**

## Project Proposal

### Title

Provide a concise and descriptive project title.

### Synopsis

Summarize the project in a few sentences. What problem does it solve? Why is it important? If you choose an idea proposed by us, this can simply be a summary of your research on the problem and/or your understanding of it.

### Benefits to the Community

Explain how this project will improve Apache DataFusion and its ecosystem. If you choose an idea proposed by us, this can simply be a summary of your understanding of potential benefits.

### Deliverables & Milestones

Consult with project mentors to come up with a rough roadmap for what you plan to accomplish, ensuring it aligns with GSoC’s timeline.

### Technical Details

Discuss the technologies, tools, and methodologies you plan to use. Mention any potential challenges and how you plan to address them.

### Related Work & References

List any relevant research, documentation, or prior work that informs your proposal.

## Personal Experience

### Relevant Skills & Background

Describe your experience with Rust, databases, and open-source contributions.

### Past Open-Source Contributions

List any prior contributions (links to PRs, issues, repositories).

### Learning Plan

Explain how you will learn new skills required for this project.

## Mentor & Communication

- **Preferred Communication Channels:** (Email, Discord, etc.)
- **Weekly Progress Updates Plan:** Describe how you plan to remain in sync with your mentor(s).

## Additional Information

Add anything else you believe strengthens your application.

```

## Final Steps

- Review your proposal for clarity and completeness.
- Submit your proposal via the GSoC portal before the deadline.
- Stay active in the community and be ready to discuss your application with mentors.

We look forward to your application and your contributions to Apache DataFusion!
