/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.vertx.core.http.HttpClosedException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.k8s.overlord.common.DruidK8sConstants;
import org.apache.druid.k8s.overlord.common.JobResponse;
import org.apache.druid.k8s.overlord.common.K8sTaskId;
import org.apache.druid.k8s.overlord.common.KubernetesClientApi;
import org.apache.druid.k8s.overlord.common.KubernetesResourceNotFoundException;
import org.apache.druid.k8s.overlord.common.PeonPhase;

public class KubernetesPeonClient {
    private static final EmittingLogger log = new EmittingLogger(KubernetesPeonClient.class);
    protected final KubernetesClientApi clientApi;
    protected final String namespace;
    protected final String overlordNamespace;
    protected final boolean debugJobs;
    private final ServiceEmitter emitter;

    public KubernetesPeonClient(KubernetesClientApi clientApi, String namespace, String overlordNamespace, boolean debugJobs, ServiceEmitter emitter) {
        this.clientApi = clientApi;
        this.namespace = namespace;
        this.overlordNamespace = overlordNamespace == null ? "" : overlordNamespace;
        this.debugJobs = debugJobs;
        this.emitter = emitter;
    }

    public Pod launchPeonJobAndWaitForStart(Job job, Task task, long howLong, TimeUnit timeUnit) throws IllegalStateException {
        long start = System.currentTimeMillis();
        return this.clientApi.executeRequest(client -> {
            String jobName = job.getMetadata().getName();
            log.info("Submitting job[%s] for task[%s].", new Object[]{jobName, task.getId()});
            this.createK8sJobWithRetries(job);
            log.info("Submitted job[%s] for task[%s]. Waiting for POD to launch.", new Object[]{jobName, task.getId()});
            Pod result = this.waitUntilPeonPodCreatedAndReady(jobName, howLong, timeUnit);
            if (result == null) {
                throw new ISE("K8s pod for the task[%s] appeared and disappeared. It can happen if the task was canceled", new Object[]{task.getId()});
            }
            log.info("Pod for job[%s] is in state[%s] for task[%s].", new Object[]{jobName, result.getStatus().getPhase(), task.getId()});
            long duration = System.currentTimeMillis() - start;
            this.emitK8sPodMetrics(task, "k8s/peon/startup/time", duration);
            return result;
        });
    }

    protected Pod waitUntilPeonPodCreatedAndReady(String jobName, long howLong, TimeUnit timeUnit) {
        Pod mainPod = this.getPeonPodWithRetries(jobName);
        log.info("Pod for job[%s] launched. Waiting for pod to be in running state.", new Object[]{jobName});
        return this.waitForPodResultWithRetries(mainPod, howLong, timeUnit);
    }

    public JobResponse waitForPeonJobCompletion(K8sTaskId taskId, long howLong, TimeUnit unit) {
        return this.clientApi.executeRequest(client -> {
            Job job = (Job)((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withName(taskId.getK8sJobName())).waitUntilCondition(x -> x == null || x.getStatus() != null && x.getStatus().getActive() == null && (x.getStatus().getFailed() != null || x.getStatus().getSucceeded() != null), howLong, unit);
            if (job == null) {
                log.info("K8s job for the task[%s] was not found. It can happen if the task was canceled", new Object[]{taskId});
                return new JobResponse(null, PeonPhase.FAILED);
            }
            if (job.getStatus().getSucceeded() != null) {
                return new JobResponse(job, PeonPhase.SUCCEEDED);
            }
            log.warn("Task[%s] failed with status[%s]", new Object[]{taskId, job.getStatus()});
            return new JobResponse(job, PeonPhase.FAILED);
        });
    }

    public boolean deletePeonJob(K8sTaskId taskId) {
        if (!this.debugJobs) {
            Boolean result = this.clientApi.executeRequest(client -> !((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withName(taskId.getK8sJobName())).delete().isEmpty());
            if (result.booleanValue()) {
                log.info("Cleaned up k8s job[%s]", new Object[]{taskId});
            } else {
                log.info("K8s job[%s] does not exist", new Object[]{taskId});
            }
            return result;
        }
        log.info("Not cleaning up job[%s] due to flag: debugJobs=true", new Object[]{taskId});
        return true;
    }

    public Optional<LogWatch> getPeonLogWatcher(K8sTaskId taskId) {
        Optional<Pod> maybePod = this.getPeonPod(taskId.getK8sJobName());
        if (!maybePod.isPresent()) {
            log.debug("Pod for job[%s] not found in cache, cannot watch logs", new Object[]{taskId.getK8sJobName()});
            return Optional.absent();
        }
        Pod pod = (Pod)maybePod.get();
        String podName = pod.getMetadata().getName();
        KubernetesClient k8sClient = this.clientApi.getClient();
        try {
            LogWatch logWatch = ((ContainerResource)((PodResource)((NonNamespaceOperation)k8sClient.pods().inNamespace(this.namespace)).withName(podName)).inContainer((Object)"main")).watchLog();
            if (logWatch == null) {
                return Optional.absent();
            }
            return Optional.of((Object)logWatch);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error watching logs from task[%s], pod[%s].", new Object[]{taskId, podName});
            return Optional.absent();
        }
    }

    public Optional<InputStream> getPeonLogs(K8sTaskId taskId) {
        Optional<Pod> maybePod = this.getPeonPod(taskId.getK8sJobName());
        if (!maybePod.isPresent()) {
            log.debug("Pod for job[%s] not found in cache, cannot stream logs", new Object[]{taskId.getK8sJobName()});
            return Optional.absent();
        }
        Pod pod = (Pod)maybePod.get();
        String podName = pod.getMetadata().getName();
        KubernetesClient k8sClient = this.clientApi.getClient();
        try {
            InputStream logStream = ((ContainerResource)((PodResource)((NonNamespaceOperation)k8sClient.pods().inNamespace(this.namespace)).resource((Object)pod)).inContainer((Object)"main")).getLogInputStream();
            if (logStream == null) {
                return Optional.absent();
            }
            return Optional.of((Object)logStream);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error streaming logs for pod[%s] associated with task[%s]", new Object[]{podName, taskId.getOriginalTaskId()});
            return Optional.absent();
        }
    }

    public List<Job> getPeonJobs() {
        return this.overlordNamespace.isEmpty() ? this.getPeonJobsWithoutOverlordNamespaceKeyLabels() : this.getPeonJobsWithOverlordNamespaceKeyLabels();
    }

    private List<Job> getPeonJobsWithoutOverlordNamespaceKeyLabels() {
        return this.clientApi.executeRequest(client -> ((JobList)((FilterWatchListDeletable)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withLabel("druid.k8s.peons")).list()).getItems());
    }

    private List<Job> getPeonJobsWithOverlordNamespaceKeyLabels() {
        return this.clientApi.executeRequest(client -> ((JobList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withLabel("druid.k8s.peons")).withLabel("druid.overlord.namespace", this.overlordNamespace)).list()).getItems());
    }

    public int deleteCompletedPeonJobsOlderThan(long howFarBack, TimeUnit timeUnit) {
        AtomicInteger numDeleted = new AtomicInteger();
        return this.clientApi.executeRequest(client -> {
            List<Job> jobs = this.getJobsToCleanup(this.getPeonJobs(), howFarBack, timeUnit);
            jobs.forEach(x -> {
                if (!((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).withName(x.getMetadata().getName())).delete().isEmpty()) {
                    numDeleted.incrementAndGet();
                } else {
                    log.error("Failed to delete job[%s]", new Object[]{x.getMetadata().getName()});
                }
            });
            return numDeleted.get();
        });
    }

    private List<Job> getJobsToCleanup(List<Job> candidates, long howFarBack, TimeUnit timeUnit) {
        ArrayList<Job> toDelete = new ArrayList<Job>();
        long cutOff = System.currentTimeMillis() - timeUnit.toMillis(howFarBack);
        candidates.forEach(x -> {
            Timestamp timestamp;
            if (x.getStatus().getActive() == null && (timestamp = Timestamp.valueOf(x.getStatus().getCompletionTime())).before(new Timestamp(cutOff))) {
                toDelete.add((Job)x);
            }
        });
        return toDelete;
    }

    public Optional<Pod> getPeonPod(String jobName) {
        return this.clientApi.executeRequest(client -> this.getPeonPod(client, jobName));
    }

    private Optional<Pod> getPeonPod(KubernetesClient client, String jobName) {
        List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withLabel("job-name", jobName)).list()).getItems();
        return pods.isEmpty() ? Optional.absent() : Optional.of((Object)((Pod)pods.get(0)));
    }

    public Pod waitForPodResultWithRetries(Pod pod, long howLong, TimeUnit timeUnit) {
        return this.clientApi.executeRequest(client -> this.waitForPodResultWithRetries(client, pod, howLong, timeUnit, 5, 10));
    }

    public Pod getPeonPodWithRetries(String jobName) {
        return this.clientApi.executeRequest(client -> this.getPeonPodWithRetries(client, jobName, 5, 10));
    }

    public void createK8sJobWithRetries(Job job) {
        this.clientApi.executeRequest(client -> {
            this.createK8sJobWithRetries(client, job, 5, 10);
            return null;
        });
    }

    @VisibleForTesting
    void createK8sJobWithRetries(KubernetesClient client, Job job, int quietTries, int maxTries) {
        try {
            RetryUtils.retry(() -> {
                try {
                    ((ScalableResource)((NonNamespaceOperation)client.batch().v1().jobs().inNamespace(this.namespace)).resource((Object)job)).create();
                    return null;
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() == 409) {
                        log.info("K8s job[%s] already exists, skipping creation", new Object[]{job.getMetadata().getName()});
                        return null;
                    }
                    throw e;
                }
            }, this::isRetryableTransientConnectionPoolException, (int)quietTries, (int)maxTries);
        }
        catch (Exception e) {
            throw DruidException.defensive((Throwable)e, (String)"Error when creating K8s job[%s]", (Object[])new Object[]{job.getMetadata().getName()});
        }
    }

    @VisibleForTesting
    Pod waitForPodResultWithRetries(KubernetesClient client, Pod pod, long howLong, TimeUnit timeUnit, int quietTries, int maxTries) {
        try {
            return (Pod)RetryUtils.retry(() -> (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(pod.getMetadata().getName())).waitUntilCondition(p -> {
                if (p == null) {
                    return true;
                }
                return p.getStatus() != null && p.getStatus().getPodIP() != null;
            }, howLong, timeUnit), this::isRetryableTransientConnectionPoolException, (int)quietTries, (int)maxTries);
        }
        catch (Exception e) {
            throw DruidException.defensive((Throwable)e, (String)"Error when waiting for pod[%s] to start", (Object[])new Object[]{pod.getMetadata().getName()});
        }
    }

    @VisibleForTesting
    Pod getPeonPodWithRetries(KubernetesClient client, String jobName, int quietTries, int maxTries) {
        try {
            return (Pod)RetryUtils.retry(() -> {
                Optional<Pod> maybePod = this.getPeonPod(client, jobName);
                if (maybePod.isPresent()) {
                    return (Pod)maybePod.get();
                }
                List<Event> events = this.getPeonEvents(client, jobName);
                if (events.isEmpty()) {
                    throw new KubernetesResourceNotFoundException("K8s pod with label[job-name=%s] not found", jobName);
                }
                Event latestEvent = events.get(events.size() - 1);
                throw new KubernetesResourceNotFoundException("Job[%s] failed to create pods. Message[%s]", jobName, latestEvent.getMessage());
            }, this::shouldRetryWaitForStartingPeonPod, (int)quietTries, (int)maxTries);
        }
        catch (KubernetesResourceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw DruidException.defensive((Throwable)e, (String)"Error when looking for K8s pod with label[job-name=%s]", (Object[])new Object[]{jobName});
        }
    }

    private boolean shouldRetryWaitForStartingPeonPod(Throwable e) {
        if (this.isRetryableTransientConnectionPoolException(e)) {
            return true;
        }
        if (!(e instanceof KubernetesResourceNotFoundException)) {
            return false;
        }
        String errorMessage = e.getMessage();
        for (String blacklistedMessage : DruidK8sConstants.BLACKLISTED_PEON_POD_ERROR_MESSAGES) {
            if (!errorMessage.contains(blacklistedMessage)) continue;
            return false;
        }
        return true;
    }

    private boolean isRetryableTransientConnectionPoolException(Throwable e) {
        if (e instanceof KubernetesClientException) {
            return e.getMessage() != null && e.getMessage().contains("Connection was closed");
        }
        return e instanceof HttpClosedException;
    }

    private List<Event> getPeonEvents(KubernetesClient client, String jobName) {
        ObjectReference objectReference = ((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withApiVersion("batch/v1")).withKind("Job")).withName(jobName)).withNamespace(this.namespace)).build();
        try {
            return ((EventList)((FilterWatchListDeletable)((NonNamespaceOperation)client.v1().events().inNamespace(this.namespace)).withInvolvedObject(objectReference)).list()).getItems();
        }
        catch (KubernetesClientException e) {
            log.warn("Failed to get events for job[%s]; %s", new Object[]{jobName, e.getMessage()});
            return List.of();
        }
    }

    private void emitK8sPodMetrics(Task task, String metric, long durationMs) {
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions((ServiceMetricEvent.Builder)metricBuilder, (Task)task);
        this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric(metric, (Number)durationMs));
    }
}

