/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.druid.java.util.emitter.EmittingLogger;

public class KubernetesResourceEventNotifier {
    private static final EmittingLogger log = new EmittingLogger(KubernetesResourceEventNotifier.class);
    private final ConcurrentHashMap<String, CompletableFuture<Job>> jobWatchers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CompletableFuture<Pod>> podWatchers = new ConcurrentHashMap();

    public CompletableFuture<Job> waitForJobChange(String jobName) {
        CompletableFuture<Job> future = new CompletableFuture<Job>();
        CompletableFuture previous = this.jobWatchers.put(jobName, future);
        if (previous != null && !previous.isDone()) {
            log.warn("Replacing active watcher for job[%s] - multiple waiters detected", new Object[]{jobName});
            previous.cancel(true);
        }
        log.debug("Registered watcher for job[%s]", new Object[]{jobName});
        return future;
    }

    public CompletableFuture<Pod> waitForPodChange(String jobName) {
        CompletableFuture<Pod> future = new CompletableFuture<Pod>();
        CompletableFuture previous = this.podWatchers.put(jobName, future);
        if (previous != null && !previous.isDone()) {
            log.warn("Replacing active watcher for pod with job-name [%s] - multiple waiters detected", new Object[]{jobName});
            previous.cancel(true);
        }
        log.debug("Registered watcher for pod with job-name [%s]", new Object[]{jobName});
        return future;
    }

    public void cancelJobWatcher(String jobName) {
        CompletableFuture<Job> future = this.jobWatchers.remove(jobName);
        if (future != null && !future.isDone()) {
            log.debug("Cancelling watcher for job[%s]", new Object[]{jobName});
            future.cancel(true);
        }
    }

    public void cancelPodWatcher(String jobName) {
        CompletableFuture<Pod> future = this.podWatchers.remove(jobName);
        if (future != null && !future.isDone()) {
            log.debug("Cancelling watcher for pod with job-name [%s]", new Object[]{jobName});
            future.cancel(true);
        }
    }

    public void notifyJobChange(String jobName, Job job) {
        CompletableFuture<Job> future = this.jobWatchers.remove(jobName);
        if (future != null) {
            log.debug("Notifying watcher of job [%s] change", new Object[]{jobName});
            future.complete(job);
        }
    }

    public void notifyPodChange(String jobName, Pod pod) {
        CompletableFuture<Pod> future = this.podWatchers.remove(jobName);
        if (future != null) {
            log.debug("Notifying watcher of pod change for job-name[%s]", new Object[]{jobName});
            future.complete(pod);
        }
    }

    public void cancelAll() {
        log.info("Cancelling all pending watchers", new Object[0]);
        this.jobWatchers.values().forEach(f -> f.cancel(true));
        this.podWatchers.values().forEach(f -> f.cancel(true));
        this.jobWatchers.clear();
        this.podWatchers.clear();
    }
}

