/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.kafka.KafkaConsumerMetric;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class KafkaConsumerMonitor
extends AbstractMonitor {
    private static final Logger log = new Logger(KafkaConsumerMonitor.class);
    private volatile boolean stopAfterNext = false;
    private static final String CLIENT_ID_TAG = "client-id";
    private static final String TOPIC_TAG = "topic";
    private static final String PARTITION_TAG = "partition";
    private static final String NODE_ID_TAG = "node-id";
    private static final String POLL_IDLE_RATIO_METRIC_NAME = "poll-idle-ratio-avg";
    private static final Map<String, KafkaConsumerMetric> METRICS = Stream.of(new KafkaConsumerMetric("bytes-consumed-total", "kafka/consumer/bytesConsumed", Set.of("client-id", "topic"), KafkaConsumerMetric.MetricType.COUNTER), new KafkaConsumerMetric("records-consumed-total", "kafka/consumer/recordsConsumed", Set.of("client-id", "topic"), KafkaConsumerMetric.MetricType.COUNTER), new KafkaConsumerMetric("fetch-total", "kafka/consumer/fetch", Set.of("client-id"), KafkaConsumerMetric.MetricType.COUNTER), new KafkaConsumerMetric("fetch-rate", "kafka/consumer/fetchRate", Set.of("client-id"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("fetch-latency-avg", "kafka/consumer/fetchLatencyAvg", Set.of("client-id"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("fetch-latency-max", "kafka/consumer/fetchLatencyMax", Set.of("client-id"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("fetch-size-avg", "kafka/consumer/fetchSizeAvg", Set.of("client-id", "topic"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("fetch-size-max", "kafka/consumer/fetchSizeMax", Set.of("client-id", "topic"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("records-lag", "kafka/consumer/recordsLag", Set.of("client-id", "topic", "partition"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("records-per-request-avg", "kafka/consumer/recordsPerRequestAvg", Set.of("client-id", "topic"), KafkaConsumerMetric.MetricType.GAUGE), new KafkaConsumerMetric("outgoing-byte-total", "kafka/consumer/outgoingBytes", Set.of("client-id", "node-id"), KafkaConsumerMetric.MetricType.COUNTER), new KafkaConsumerMetric("incoming-byte-total", "kafka/consumer/incomingBytes", Set.of("client-id", "node-id"), KafkaConsumerMetric.MetricType.COUNTER)).collect(Collectors.toMap(KafkaConsumerMetric::getKafkaMetricName, Function.identity()));
    private final KafkaConsumer<?, ?> consumer;
    private final Map<MetricName, AtomicLong> counters = new HashMap<MetricName, AtomicLong>();
    private final AtomicDouble pollIdleRatioAvg = new AtomicDouble(1.0);

    public KafkaConsumerMonitor(KafkaConsumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        for (Map.Entry entry : this.consumer.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            KafkaConsumerMetric kafkaConsumerMetric = METRICS.get(metricName.name());
            if (kafkaConsumerMetric != null && kafkaConsumerMetric.getDimensions().equals(metricName.tags().keySet())) {
                Number emitValue;
                Number newValue = (Number)((Metric)entry.getValue()).metricValue();
                if (kafkaConsumerMetric.getMetricType() == KafkaConsumerMetric.MetricType.GAUGE || newValue == null) {
                    emitValue = newValue;
                } else if (kafkaConsumerMetric.getMetricType() == KafkaConsumerMetric.MetricType.COUNTER) {
                    long newValueAsLong = newValue.longValue();
                    long priorValue = this.counters.computeIfAbsent(metricName, ignored -> new AtomicLong()).getAndSet(newValueAsLong);
                    emitValue = newValueAsLong - priorValue;
                } else {
                    throw DruidException.defensive((String)"Unexpected metric type[%s]", (Object[])new Object[]{kafkaConsumerMetric.getMetricType()});
                }
                if (emitValue != null && !Double.isNaN(emitValue.doubleValue())) {
                    ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                    for (String dimension : kafkaConsumerMetric.getDimensions()) {
                        if (CLIENT_ID_TAG.equals(dimension)) continue;
                        builder.setDimension(dimension, metricName.tags().get(dimension));
                    }
                    emitter.emit((ServiceEventBuilder)builder.setMetric(kafkaConsumerMetric.getDruidMetricName(), emitValue));
                }
            }
            if (!POLL_IDLE_RATIO_METRIC_NAME.equals(metricName.name()) || ((Metric)entry.getValue()).metricValue() == null) continue;
            this.pollIdleRatioAvg.set(((Number)((Metric)entry.getValue()).metricValue()).doubleValue());
        }
        return !this.stopAfterNext;
    }

    public void stopAfterNextEmit() {
        this.stopAfterNext = true;
    }

    public double getPollIdleRatioAvg() {
        return this.pollIdleRatioAvg.get();
    }
}

