/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class NodeAttribute {
    public static final String PREFIX_DISTRIBUTED = "nm.yarn.io";
    public static final String PREFIX_CENTRALIZED = "rm.yarn.io";

    public static NodeAttribute newInstance(String attributeName, NodeAttributeType attributeType, String attributeValue) {
        return NodeAttribute.newInstance(PREFIX_CENTRALIZED, attributeName, attributeType, attributeValue);
    }

    public static NodeAttribute newInstance(String attributePrefix, String attributeName, NodeAttributeType attributeType, String attributeValue) {
        NodeAttribute nodeAttribute = Records.newRecord(NodeAttribute.class);
        NodeAttributeKey nodeAttributeKey = NodeAttributeKey.newInstance(attributePrefix, attributeName);
        nodeAttribute.setAttributeKey(nodeAttributeKey);
        nodeAttribute.setAttributeType(attributeType);
        nodeAttribute.setAttributeValue(attributeValue);
        return nodeAttribute;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract NodeAttributeKey getAttributeKey();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setAttributeKey(NodeAttributeKey var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getAttributeValue();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setAttributeValue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract NodeAttributeType getAttributeType();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setAttributeType(NodeAttributeType var1);
}

