/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.druid.jackson.DefaultTrueJsonIncludeFilter;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchModule;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchOperations;
import org.apache.druid.query.aggregation.datasketches.quantiles.NoopDoublesSketchAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.NoopDoublesSketchBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoublesSketchAggregatorFactory
extends AggregatorFactory {
    public static final Comparator<DoublesSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(DoublesSketch::getN));
    public static final int DEFAULT_K = 128;
    public static final boolean DEFAULT_SHOULD_FINALIZE = true;
    public static final long DEFAULT_MAX_STREAM_LENGTH = 1000000000L;
    private final String name;
    private final String fieldName;
    private final int k;
    private final long maxStreamLength;
    private final boolean shouldFinalize;
    private final byte cacheTypeId;

    @JsonCreator
    public DoublesSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="k") @Nullable Integer k, @JsonProperty(value="maxStreamLength") @Nullable Long maxStreamLength, @JsonProperty(value="shouldFinalize") @Nullable Boolean shouldFinalize) {
        this(name, fieldName, k, maxStreamLength, shouldFinalize, 27);
    }

    @VisibleForTesting
    public DoublesSketchAggregatorFactory(String name, String fieldName, @Nullable Integer k) {
        this(name, fieldName, k, null, true);
    }

    DoublesSketchAggregatorFactory(String name, String fieldName, @Nullable Integer k, @Nullable Long maxStreamLength, @Nullable Boolean shouldFinalize, byte cacheTypeId) {
        if (name == null) {
            throw new IAE("Must have a valid, non-null aggregator name", new Object[0]);
        }
        this.name = name;
        if (fieldName == null) {
            throw new IAE("Parameter fieldName must be specified", new Object[0]);
        }
        this.fieldName = fieldName;
        this.k = k == null ? 128 : k;
        Util.checkIfIntPowerOf2((int)this.k, (String)"k");
        this.maxStreamLength = maxStreamLength == null ? 1000000000L : maxStreamLength;
        this.shouldFinalize = shouldFinalize == null ? true : shouldFinalize;
        this.cacheTypeId = cacheTypeId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && metricFactory.getColumnCapabilities(this.fieldName).isNumeric()) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new NoopDoublesSketchAggregator();
            }
            return new DoublesSketchBuildAggregator((ColumnValueSelector<Double>)selector, this.k);
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new NoopDoublesSketchAggregator();
        }
        return new DoublesSketchMergeAggregator(selector, this.k);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && metricFactory.getColumnCapabilities(this.fieldName).isNumeric()) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new NoopDoublesSketchBufferAggregator();
            }
            return new DoublesSketchBuildBufferAggregator((BaseDoubleColumnValueSelector)selector, this.k, this.getMaxIntermediateSizeWithNulls());
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new NoopDoublesSketchBufferAggregator();
        }
        return new DoublesSketchMergeBufferAggregator((ColumnValueSelector<DoublesSketch>)selector, this.k, this.getMaxIntermediateSizeWithNulls());
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return (VectorAggregator)ColumnProcessors.makeVectorProcessor((String)this.fieldName, (VectorColumnProcessorFactory)new VectorColumnProcessorFactory<VectorAggregator>(){

            public VectorAggregator makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
                return new NoopDoublesSketchBufferAggregator();
            }

            public VectorAggregator makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
                return new NoopDoublesSketchBufferAggregator();
            }

            public VectorAggregator makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new DoublesSketchBuildVectorAggregator(selector, DoublesSketchAggregatorFactory.this.k, DoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new DoublesSketchBuildVectorAggregator(selector, DoublesSketchAggregatorFactory.this.k, DoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
                return new DoublesSketchBuildVectorAggregator(selector, DoublesSketchAggregatorFactory.this.k, DoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }

            public VectorAggregator makeArrayProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
                return new NoopDoublesSketchBufferAggregator();
            }

            public VectorAggregator makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
                return new DoublesSketchMergeVectorAggregator(selector, DoublesSketchAggregatorFactory.this.k, DoublesSketchAggregatorFactory.this.getMaxIntermediateSizeWithNulls());
            }
        }, (VectorColumnSelectorFactory)selectorFactory);
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public Object deserialize(Object object) {
        return DoublesSketchOperations.deserialize(object);
    }

    public Comparator<DoublesSketch> getComparator() {
        return COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        DoublesUnion union = DoublesUnion.builder().setMaxK(this.k).build();
        if (lhs != null) {
            union.union((DoublesSketch)lhs);
        }
        if (rhs != null) {
            union.union((DoublesSketch)rhs);
        }
        return union.getResultAndReset();
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<DoublesSketch>(){
            private final DoublesUnion union;
            {
                this.union = DoublesUnion.builder().setMaxK(DoublesSketchAggregatorFactory.this.k).build();
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                DoublesSketch sketch = (DoublesSketch)selector.getObject();
                if (sketch != null) {
                    this.union.union(sketch);
                }
            }

            @Nullable
            public DoublesSketch getObject() {
                return this.union.getResult();
            }

            public Class<DoublesSketch> classOfObject() {
                return DoublesSketch.class;
            }
        };
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getK() {
        return this.k;
    }

    @JsonProperty
    public long getMaxStreamLength() {
        return this.maxStreamLength;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=DefaultTrueJsonIncludeFilter.class)
    public boolean isShouldFinalize() {
        return this.shouldFinalize;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public int guessAggregatorHeapFootprint(long rows) {
        return DoublesSketch.getUpdatableStorageBytes((int)this.k, (long)rows);
    }

    public AggregatorFactory withName(String newName) {
        return new DoublesSketchAggregatorFactory(newName, this.getFieldName(), this.getK(), this.getMaxStreamLength(), this.shouldFinalize, this.cacheTypeId);
    }

    public int getMaxIntermediateSize() {
        return DoublesSketch.getUpdatableStorageBytes((int)this.k, (long)this.maxStreamLength);
    }

    public AggregatorFactory getCombiningFactory() {
        return new DoublesSketchMergeAggregatorFactory(this.name, this.k, this.maxStreamLength, this.shouldFinalize);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof DoublesSketchAggregatorFactory) {
            DoublesSketchAggregatorFactory castedOther = (DoublesSketchAggregatorFactory)other;
            if (castedOther.shouldFinalize == this.shouldFinalize) {
                return new DoublesSketchMergeAggregatorFactory(this.name, Math.max(this.k, castedOther.k), Math.max(this.maxStreamLength, castedOther.maxStreamLength), this.shouldFinalize);
            }
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (!this.shouldFinalize || object == null) {
            return object;
        }
        return ((DoublesSketch)object).getN();
    }

    public ColumnType getIntermediateType() {
        return DoublesSketchModule.TYPE;
    }

    public ColumnType getResultType() {
        if (this.shouldFinalize) {
            return ColumnType.LONG;
        }
        return this.getIntermediateType();
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.cacheTypeId).appendString(this.name).appendString(this.fieldName).appendInt(this.k).build();
    }

    @Nullable
    public AggregatorFactory substituteCombiningFactory(AggregatorFactory preAggregated) {
        if (this == preAggregated) {
            return this.getCombiningFactory();
        }
        if (((Object)((Object)this)).getClass() != preAggregated.getClass()) {
            return null;
        }
        DoublesSketchAggregatorFactory that = (DoublesSketchAggregatorFactory)preAggregated;
        if (this.k <= that.k && this.maxStreamLength <= that.getMaxStreamLength() && Objects.equals(this.fieldName, that.fieldName)) {
            return this.getCombiningFactory();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DoublesSketchAggregatorFactory that = (DoublesSketchAggregatorFactory)((Object)o);
        return this.k == that.k && this.maxStreamLength == that.maxStreamLength && this.shouldFinalize == that.shouldFinalize && this.name.equals(that.name) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.k, this.maxStreamLength, this.shouldFinalize);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name=" + this.name + ", fieldName=" + this.fieldName + ", k=" + this.k + "}";
    }
}

