/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.NoopDoublesSketchAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.NoopDoublesSketchBufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;

public class DoublesSketchMergeAggregatorFactory
extends DoublesSketchAggregatorFactory {
    @JsonCreator
    public DoublesSketchMergeAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="k") @Nullable Integer k, @JsonProperty(value="maxStreamLength") @Nullable Long maxStreamLength, @JsonProperty(value="shouldFinalize") @Nullable Boolean shouldFinalize) {
        super(name, name, k, maxStreamLength, shouldFinalize, (byte)28);
    }

    @VisibleForTesting
    DoublesSketchMergeAggregatorFactory(String name, @Nullable Integer k) {
        this(name, k, null, null);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.getFieldName());
        if (selector instanceof NilColumnValueSelector) {
            return new NoopDoublesSketchAggregator();
        }
        return new DoublesSketchMergeAggregator(selector, this.getK());
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.getFieldName());
        if (selector instanceof NilColumnValueSelector) {
            return new NoopDoublesSketchBufferAggregator();
        }
        return new DoublesSketchMergeBufferAggregator((ColumnValueSelector<DoublesSketch>)selector, this.getK(), this.getMaxIntermediateSizeWithNulls());
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new DoublesSketchMergeAggregatorFactory(newName, this.getK(), this.getMaxStreamLength(), this.isShouldFinalize());
    }
}

