/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.theta.Union;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class SketchBufferAggregator
implements BufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final SketchBufferAggregatorHelper helper;

    public SketchBufferAggregator(BaseObjectColumnValueSelector selector, int size, int maxIntermediateSize) {
        this.selector = selector;
        this.helper = new SketchBufferAggregatorHelper(size, maxIntermediateSize);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.getObject();
        if (update == null) {
            return;
        }
        Union union = this.helper.getOrCreateUnion(buf, position);
        SketchAggregator.updateUnion(union, update);
    }

    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.helper.clear();
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (Object)this.selector);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }
}

