/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CopyDBSnapshotRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyDBSnapshotRequestMarshaller
implements Marshaller<Request<CopyDBSnapshotRequest>, CopyDBSnapshotRequest> {
    public Request<CopyDBSnapshotRequest> marshall(CopyDBSnapshotRequest copyDBSnapshotRequest) {
        if (copyDBSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBSnapshotRequest, "AmazonRDS");
        request.addParameter("Action", "CopyDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBSnapshotRequest.getSourceDBSnapshotIdentifier() != null) {
            request.addParameter("SourceDBSnapshotIdentifier", StringUtils.fromString((String)copyDBSnapshotRequest.getSourceDBSnapshotIdentifier()));
        }
        if (copyDBSnapshotRequest.getTargetDBSnapshotIdentifier() != null) {
            request.addParameter("TargetDBSnapshotIdentifier", StringUtils.fromString((String)copyDBSnapshotRequest.getTargetDBSnapshotIdentifier()));
        }
        if (copyDBSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyDBSnapshotRequest.getKmsKeyId()));
        }
        if (!copyDBSnapshotRequest.getTags().isEmpty() || !((SdkInternalList)copyDBSnapshotRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)copyDBSnapshotRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (copyDBSnapshotRequest.getCopyTags() != null) {
            request.addParameter("CopyTags", StringUtils.fromBoolean((Boolean)copyDBSnapshotRequest.getCopyTags()));
        }
        if (copyDBSnapshotRequest.getPreSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)copyDBSnapshotRequest.getPreSignedUrl()));
        }
        if (copyDBSnapshotRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)copyDBSnapshotRequest.getOptionGroupName()));
        }
        if (copyDBSnapshotRequest.getTargetCustomAvailabilityZone() != null) {
            request.addParameter("TargetCustomAvailabilityZone", StringUtils.fromString((String)copyDBSnapshotRequest.getTargetCustomAvailabilityZone()));
        }
        if (copyDBSnapshotRequest.getCopyOptionGroup() != null) {
            request.addParameter("CopyOptionGroup", StringUtils.fromBoolean((Boolean)copyDBSnapshotRequest.getCopyOptionGroup()));
        }
        if (copyDBSnapshotRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copyDBSnapshotRequest.getSourceRegion()));
        }
        return request;
    }
}

