/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.StartExportTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StartExportTaskRequestMarshaller
implements Marshaller<Request<StartExportTaskRequest>, StartExportTaskRequest> {
    public Request<StartExportTaskRequest> marshall(StartExportTaskRequest startExportTaskRequest) {
        if (startExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startExportTaskRequest, "AmazonRDS");
        request.addParameter("Action", "StartExportTask");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startExportTaskRequest.getExportTaskIdentifier() != null) {
            request.addParameter("ExportTaskIdentifier", StringUtils.fromString((String)startExportTaskRequest.getExportTaskIdentifier()));
        }
        if (startExportTaskRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)startExportTaskRequest.getSourceArn()));
        }
        if (startExportTaskRequest.getS3BucketName() != null) {
            request.addParameter("S3BucketName", StringUtils.fromString((String)startExportTaskRequest.getS3BucketName()));
        }
        if (startExportTaskRequest.getIamRoleArn() != null) {
            request.addParameter("IamRoleArn", StringUtils.fromString((String)startExportTaskRequest.getIamRoleArn()));
        }
        if (startExportTaskRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)startExportTaskRequest.getKmsKeyId()));
        }
        if (startExportTaskRequest.getS3Prefix() != null) {
            request.addParameter("S3Prefix", StringUtils.fromString((String)startExportTaskRequest.getS3Prefix()));
        }
        if (!startExportTaskRequest.getExportOnly().isEmpty() || !((SdkInternalList)startExportTaskRequest.getExportOnly()).isAutoConstruct()) {
            SdkInternalList exportOnlyList = (SdkInternalList)startExportTaskRequest.getExportOnly();
            int exportOnlyListIndex = 1;
            for (String exportOnlyListValue : exportOnlyList) {
                if (exportOnlyListValue != null) {
                    request.addParameter("ExportOnly.member." + exportOnlyListIndex, StringUtils.fromString((String)exportOnlyListValue));
                }
                ++exportOnlyListIndex;
            }
        }
        return request;
    }
}

