/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.validator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.security.basic.BasicAuthLDAPConfig;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityAuthenticationException;
import org.apache.druid.security.basic.BasicSecuritySSLSocketFactory;
import org.apache.druid.security.basic.authentication.LdapUserPrincipal;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentials;
import org.apache.druid.security.basic.authentication.validator.CredentialsValidator;
import org.apache.druid.security.basic.authentication.validator.PasswordHashGenerator;
import org.apache.druid.server.security.AuthenticationResult;

@JsonTypeName(value="ldap")
public class LDAPCredentialsValidator
implements CredentialsValidator {
    private static final Logger LOG = new Logger(LDAPCredentialsValidator.class);
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final LruBlockCache cache;
    private final PasswordHashGenerator hashGenerator = new PasswordHashGenerator();
    private final BasicAuthLDAPConfig ldapConfig;
    @Nullable
    private final Properties overrideProperties;

    @JsonCreator
    public LDAPCredentialsValidator(@JsonProperty(value="url") String url, @JsonProperty(value="bindUser") String bindUser, @JsonProperty(value="bindPassword") PasswordProvider bindPassword, @JsonProperty(value="baseDn") String baseDn, @JsonProperty(value="userSearch") String userSearch, @JsonProperty(value="userAttribute") String userAttribute, @JsonProperty(value="credentialIterations") Integer credentialIterations, @JsonProperty(value="credentialVerifyDuration") Integer credentialVerifyDuration, @JsonProperty(value="credentialMaxDuration") Integer credentialMaxDuration, @JsonProperty(value="credentialCacheSize") Integer credentialCacheSize) {
        this.ldapConfig = new BasicAuthLDAPConfig(url, bindUser, bindPassword, baseDn, userSearch, userAttribute, credentialIterations == null ? 10000 : credentialIterations, credentialVerifyDuration == null ? 600 : credentialVerifyDuration, credentialMaxDuration == null ? 3600 : credentialMaxDuration, credentialCacheSize == null ? 100 : credentialCacheSize);
        this.cache = new LruBlockCache((int)this.ldapConfig.getCredentialCacheSize(), this.ldapConfig.getCredentialVerifyDuration(), this.ldapConfig.getCredentialMaxDuration());
        this.overrideProperties = null;
    }

    @VisibleForTesting
    public LDAPCredentialsValidator(BasicAuthLDAPConfig ldapConfig, LruBlockCache cache, Properties overrideProperties) {
        this.ldapConfig = ldapConfig;
        this.cache = cache;
        this.overrideProperties = overrideProperties;
    }

    Properties bindProperties(BasicAuthLDAPConfig ldapConfig) {
        Properties properties = this.commonProperties(ldapConfig);
        properties.put("java.naming.security.principal", ldapConfig.getBindUser());
        properties.put("java.naming.security.credentials", ldapConfig.getBindPassword().getPassword());
        return properties;
    }

    Properties userProperties(BasicAuthLDAPConfig ldapConfig, LdapName userDn, char[] password) {
        Properties properties = this.commonProperties(ldapConfig);
        properties.put("java.naming.security.principal", userDn.toString());
        properties.put("java.naming.security.credentials", String.valueOf(password));
        return properties;
    }

    Properties commonProperties(BasicAuthLDAPConfig ldapConfig) {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", ldapConfig.getUrl());
        properties.put("java.naming.security.authentication", "simple");
        if (StringUtils.toLowerCase((String)ldapConfig.getUrl()).startsWith("ldaps://")) {
            properties.put("java.naming.security.protocol", "ssl");
            properties.put("java.naming.ldap.factory.socket", BasicSecuritySSLSocketFactory.class.getName());
        }
        if (null != this.overrideProperties) {
            properties.putAll((Map<?, ?>)this.overrideProperties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationResult validateCredentials(String authenticatorName, String authorizerName, String username, char[] password) {
        if (username.isEmpty() || password.length == 0) {
            return null;
        }
        HashMap<String, SearchResult> contextMap = new HashMap<String, SearchResult>();
        LdapUserPrincipal principal = this.cache.getOrExpire(username);
        if (principal != null && principal.hasSameCredentials(password, this.hashGenerator)) {
            contextMap.put("searchResult", principal.getSearchResult());
        } else {
            LdapName userDn;
            SearchResult userResult;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                InitialDirContext dirContext = new InitialDirContext(this.bindProperties(this.ldapConfig));
                try {
                    userResult = this.getLdapUserObject(this.ldapConfig, dirContext, username);
                    if (userResult == null) {
                        LOG.debug("User not found: %s", new Object[]{username});
                        AuthenticationResult authenticationResult = null;
                        return authenticationResult;
                    }
                    userDn = new LdapName(userResult.getNameInNamespace());
                }
                finally {
                    try {
                        dirContext.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Exception during user lookup", new Object[0]);
                AuthenticationResult authenticationResult = null;
                return authenticationResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            if (!this.validatePassword(this.ldapConfig, userDn, password)) {
                LOG.debug("Password incorrect for LDAP user %s", new Object[]{username});
                throw new BasicSecurityAuthenticationException("Unauthorized", new Object[0]);
            }
            byte[] salt = BasicAuthUtils.generateSalt();
            byte[] hash = this.hashGenerator.getOrComputePasswordHash(password, salt, this.ldapConfig.getCredentialIterations());
            LdapUserPrincipal newPrincipal = new LdapUserPrincipal(username, new BasicAuthenticatorCredentials(salt, hash, this.ldapConfig.getCredentialIterations()), userResult);
            this.cache.put(username, newPrincipal);
            contextMap.put("searchResult", userResult);
        }
        return new AuthenticationResult(username, authorizerName, authenticatorName, contextMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    SearchResult getLdapUserObject(BasicAuthLDAPConfig ldapConfig, DirContext context, String username) {
        try {
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setReturningAttributes(new String[]{ldapConfig.getUserAttribute(), "memberOf"});
            String encodedUsername = LDAPCredentialsValidator.encodeForLDAP(username, true);
            try (NamingEnumeration<SearchResult> results = context.search(ldapConfig.getBaseDn(), StringUtils.format((String)ldapConfig.getUserSearch(), (Object[])new Object[]{encodedUsername}), sc);){
                if (!results.hasMore()) {
                    SearchResult searchResult = null;
                    return searchResult;
                }
                SearchResult searchResult = results.next();
                return searchResult;
            }
        }
        catch (NamingException e) {
            LOG.debug((Throwable)e, "Unable to find user '%s'", new Object[]{username});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validatePassword(BasicAuthLDAPConfig ldapConfig, LdapName userDn, char[] password) {
        InitialContext context = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            context = new InitialDirContext(this.userProperties(ldapConfig, userDn, password));
            boolean bl = true;
            return bl;
        }
        catch (AuthenticationException e) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "Exception during LDAP authentication username[%s]", new Object[]{userDn.toString()});
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception ignored) {
                LOG.warn("Exception closing LDAP context", new Object[0]);
            }
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public static String encodeForLDAP(String input, boolean encodeWildcards) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\5c");
                    continue block8;
                }
                case '/': {
                    sb.append("\\2f");
                    continue block8;
                }
                case '*': {
                    if (encodeWildcards) {
                        sb.append("\\2a");
                        continue block8;
                    }
                    sb.append(c);
                    continue block8;
                }
                case '(': {
                    sb.append("\\28");
                    continue block8;
                }
                case ')': {
                    sb.append("\\29");
                    continue block8;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static class LruBlockCache
    extends LinkedHashMap<String, LdapUserPrincipal> {
        private static final long serialVersionUID = 7509410739092012261L;
        private final int cacheSize;
        private final int duration;
        private final int maxDuration;

        public LruBlockCache(int cacheSize, int duration, int maxDuration) {
            super(16, 0.75f, true);
            this.cacheSize = cacheSize;
            this.duration = duration;
            this.maxDuration = maxDuration;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, LdapUserPrincipal> eldest) {
            return this.size() > this.cacheSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        LdapUserPrincipal getOrExpire(String identity) {
            try {
                LOCK.lock();
                LdapUserPrincipal principal = (LdapUserPrincipal)this.get(identity);
                if (principal != null) {
                    if (principal.isExpired(this.duration, this.maxDuration)) {
                        this.remove(identity);
                        LdapUserPrincipal ldapUserPrincipal = null;
                        return ldapUserPrincipal;
                    }
                    LdapUserPrincipal ldapUserPrincipal = principal;
                    return ldapUserPrincipal;
                }
                LdapUserPrincipal ldapUserPrincipal = null;
                return ldapUserPrincipal;
            }
            finally {
                LOCK.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LdapUserPrincipal put(String key, LdapUserPrincipal value) {
            try {
                LOCK.lock();
                LdapUserPrincipal ldapUserPrincipal = super.put(key, value);
                return ldapUserPrincipal;
            }
            finally {
                LOCK.unlock();
            }
        }
    }
}

