/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.name.Named;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.indexing.kinesis.KinesisIndexTask;
import org.apache.druid.indexing.kinesis.KinesisRecordSupplier;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorIOConfig;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorSpec;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorTuningConfig;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamSamplerSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.server.security.ResourceAction;

public class KinesisSamplerSpec
extends SeekableStreamSamplerSpec {
    private static final int DEFAULT_RECORDS_PER_FETCH = 100;
    private final AWSCredentialsConfig awsCredentialsConfig;

    @JsonCreator
    public KinesisSamplerSpec(@JsonProperty(value="spec") KinesisSupervisorSpec ingestionSpec, @JsonProperty(value="samplerConfig") @Nullable SamplerConfig samplerConfig, @JacksonInject InputSourceSampler inputSourceSampler, @JacksonInject @Named(value="kinesis") AWSCredentialsConfig awsCredentialsConfig) {
        super((SeekableStreamSupervisorSpec)ingestionSpec, samplerConfig, inputSourceSampler);
        this.awsCredentialsConfig = awsCredentialsConfig;
    }

    protected KinesisRecordSupplier createRecordSupplier() {
        KinesisSupervisorIOConfig ioConfig = (KinesisSupervisorIOConfig)this.ioConfig;
        KinesisSupervisorTuningConfig tuningConfig = (KinesisSupervisorTuningConfig)this.tuningConfig;
        return new KinesisRecordSupplier(KinesisRecordSupplier.getAmazonKinesisClient(ioConfig.getEndpoint(), this.awsCredentialsConfig, ioConfig.getAwsAssumedRoleArn(), ioConfig.getAwsExternalId()), ioConfig.getFetchDelayMillis(), 1, tuningConfig.getRecordBufferSizeBytesOrDefault(Runtime.getRuntime().maxMemory()), tuningConfig.getRecordBufferOfferTimeout(), tuningConfig.getRecordBufferFullWait(), tuningConfig.getMaxBytesPerPollOrDefault(), ioConfig.isUseEarliestSequenceNumber(), tuningConfig.isUseListShards());
    }

    public String getType() {
        return "kinesis";
    }

    @Nonnull
    public Set<ResourceAction> getInputSourceResources() throws UOE {
        return KinesisIndexTask.INPUT_SOURCE_RESOURCES;
    }
}

