/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.druid.msq.util.MultiStageQueryContext;

import java.util.Objects;

@JsonTypeName(TooManyPartitionsFault.CODE)
public class TooManyPartitionsFault extends BaseMSQFault
{
  static final String CODE = "TooManyPartitions";

  private final int maxPartitions;

  @JsonCreator
  public TooManyPartitionsFault(@JsonProperty("maxPartitions") final int maxPartitions)
  {
    super(
        CODE,
        "Too many partitions (max = %d). Try increasing the limit using the %s query context parameter, "
        + "breaking your query up into smaller queries, or using a larger target size.",
        maxPartitions,
        MultiStageQueryContext.CTX_MAX_PARTITIONS
    );
    this.maxPartitions = maxPartitions;
  }

  @JsonProperty
  public int getMaxPartitions()
  {
    return maxPartitions;
  }

  @Override
  public boolean equals(Object o)
  {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    if (!super.equals(o)) {
      return false;
    }
    TooManyPartitionsFault that = (TooManyPartitionsFault) o;
    return maxPartitions == that.maxPartitions;
  }

  @Override
  public int hashCode()
  {
    return Objects.hash(super.hashCode(), maxPartitions);
  }
}
