/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.msq.counters;

import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.msq.guice.MSQIndexingModule;
import org.apache.druid.segment.TestHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NilQueryCounterSnapshotTest
{
  private ObjectMapper objectMapper;

  @BeforeEach
  public void setUp()
  {
    objectMapper = TestHelper.JSON_MAPPER.copy();
    objectMapper.registerModules(new MSQIndexingModule().getJacksonModules());
  }

  @Test
  public void testSerde() throws Exception
  {
    final NilQueryCounterSnapshot snapshot = NilQueryCounterSnapshot.instance();
    final String json = objectMapper.writeValueAsString(snapshot);
    final QueryCounterSnapshot deserialized = objectMapper.readValue(json, QueryCounterSnapshot.class);
    Assertions.assertEquals(snapshot, deserialized);
    Assertions.assertSame(NilQueryCounterSnapshot.instance(), deserialized);
  }

  @Test
  public void testDeserializeFromUnknownType() throws Exception
  {
    final String json = "{\"type\": \"nonexistent\"}";
    final QueryCounterSnapshot deserialized = objectMapper.readValue(json, QueryCounterSnapshot.class);
    Assertions.assertEquals(NilQueryCounterSnapshot.instance(), deserialized);
    Assertions.assertSame(NilQueryCounterSnapshot.instance(), deserialized);
  }

  @Test
  public void testEqualsAndHashCode()
  {
    EqualsVerifier.forClass(NilQueryCounterSnapshot.class)
                  .usingGetClass()
                  .verify();
  }
}
