/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { shallow } from '../../../utils/shallow-renderer';

import { QueryParametersDialog } from './query-parameters-dialog';

describe('QueryParametersDialog', () => {
  it('matches snapshot', () => {
    const comp = shallow(
      <QueryParametersDialog
        queryParameters={[
          { type: 'VARCHAR', value: 'Hello world' },
          { type: 'TIMESTAMP', value: '2022-02-02 01:02:03' },
          { type: 'BIGINT', value: 42 },
          { type: 'DOUBLE', value: 1.618 },
          { type: 'ARRAY', value: [-25.7, null, 36.85] },
        ]}
        onQueryParametersChange={() => {}}
        onClose={() => {}}
      />,
    );

    expect(comp).toMatchSnapshot();
  });

  it('handles ARRAY type parameters correctly', () => {
    const comp = shallow(
      <QueryParametersDialog
        queryParameters={[
          { type: 'ARRAY', value: [1, 2, 3] },
          { type: 'ARRAY', value: ['a', 'b', null] },
          { type: 'ARRAY', value: [] },
        ]}
        onQueryParametersChange={() => {}}
        onClose={() => {}}
      />,
    );

    expect(comp).toMatchSnapshot();
  });
});
