/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.SqlFunctionUtils;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class RegexpCountFunction
extends BuiltInScalarFunction {
    public RegexpCountFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.REGEXP_COUNT, context);
    }

    @Nullable
    public Integer eval(@Nullable StringData str, @Nullable StringData regex) {
        Matcher matcher = SqlFunctionUtils.getRegexpMatcher(str, regex);
        if (matcher == null) {
            return null;
        }
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }
}

