/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplicitModelCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.flink.table.planner.catalog.CatalogSchemaModel;

public class SqlModelCall
extends SqlBasicCall {
    private final CatalogSchemaModel model;

    public SqlModelCall(SqlExplicitModelCall modelCall, CatalogSchemaModel model) {
        super((SqlOperator)new SqlModelOperator(model), modelCall.getOperandList(), modelCall.getParserPosition(), modelCall.getFunctionQuantifier());
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    public RelDataType getInputType(SqlValidator validator) {
        return this.model.getInputRowType(validator.getTypeFactory());
    }

    public RelDataType getOutputType(SqlValidator validator) {
        return this.model.getOutputRowType(validator.getTypeFactory());
    }

    public CatalogSchemaModel getModel() {
        return this.model;
    }

    private static class SqlModelOperator
    extends SqlPrefixOperator {
        CatalogSchemaModel model;

        private SqlModelOperator(CatalogSchemaModel model) {
            super("MODEL", SqlKind.OTHER_FUNCTION, 2, null, null, null);
            this.model = model;
        }

        @Override
        public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
            return this.model.getOutputRowType(validator.getTypeFactory());
        }
    }
}

