/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.sort.LimitOperator;
import org.apache.flink.table.types.logical.LogicalType;

@ExecNodeMetadata(name="batch-exec-limit", version=1, producedTransformations={"limit"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecLimit
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String LIMIT_TRANSFORMATION = "limit";
    public static final String FIELD_NAME_LIMIT_START = "limitStart";
    public static final String FIELD_NAME_LIMIT_END = "limitEnd";
    public static final String FIELD_NAME_IS_GLOBAL = "isGlobal";
    @JsonProperty(value="limitStart")
    private final long limitStart;
    @JsonProperty(value="limitEnd")
    private final long limitEnd;
    @JsonProperty(value="isGlobal")
    private final boolean isGlobal;

    public BatchExecLimit(ReadableConfig tableConfig, long limitStart, long limitEnd, boolean isGlobal, InputProperty inputProperty, LogicalType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecLimit.class), ExecNodeContext.newPersistedConfig(BatchExecLimit.class, tableConfig), Collections.singletonList(inputProperty), outputType, description);
        this.isGlobal = isGlobal;
        this.limitStart = limitStart;
        this.limitEnd = limitEnd;
    }

    @JsonCreator
    public BatchExecLimit(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="limitStart") long limitStart, @JsonProperty(value="limitEnd") long limitEnd, @JsonProperty(value="isGlobal") boolean isGlobal, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") LogicalType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, outputType, description);
        this.isGlobal = isGlobal;
        this.limitStart = limitStart;
        this.limitEnd = limitEnd;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<?> inputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        LimitOperator operator = new LimitOperator(this.isGlobal, this.limitStart, this.limitEnd);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(LIMIT_TRANSFORMATION, config), SimpleOperatorFactory.of((StreamOperator)operator), inputTransform.getOutputType(), inputTransform.getParallelism(), false);
    }
}

