/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;

@Internal
public class FlinkLogicalMultiJoin
extends AbstractRelNode
implements FlinkLogicalRel {
    public static final Converter CONVERTER = new Converter(ConverterRule.Config.INSTANCE.withConversion(MultiJoin.class, Convention.NONE, FlinkConventions.LOGICAL(), "FlinkLogicalMultiJoinConverter"));
    private List<RelNode> inputs;
    private final RexNode joinFilter;
    private final List<JoinRelType> joinTypes;
    private final List<? extends @Nullable RexNode> joinConditions;
    private final @Nullable RexNode postJoinFilter;
    private final List<RelHint> hints;

    public FlinkLogicalMultiJoin(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, List<? extends @Nullable RexNode> joinConditions, List<JoinRelType> joinTypes, @Nullable RexNode postJoinFilter, List<RelHint> hints) {
        super(cluster, traitSet);
        this.inputs = inputs;
        this.rowType = rowType;
        this.joinFilter = joinFilter;
        this.joinTypes = joinTypes;
        this.joinConditions = joinConditions;
        this.postJoinFilter = postJoinFilter;
        this.hints = hints;
    }

    public static FlinkLogicalMultiJoin create(RelOptCluster cluster, List<RelNode> inputs, RexNode joinFilter, RelDataType rowType, List<? extends @Nullable RexNode> joinConditions, List<JoinRelType> joinTypes, @Nullable RexNode postJoinFilter, List<RelHint> hints) {
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)FlinkConventions.LOGICAL()).simplify();
        return new FlinkLogicalMultiJoin(cluster, traitSet, inputs, joinFilter, rowType, joinConditions, joinTypes, postJoinFilter, hints);
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        assert (ordinalInParent >= 0 && ordinalInParent < this.inputs.size());
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = List.copyOf(newInputs);
        this.recomputeDigest();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new FlinkLogicalMultiJoin(this.getCluster(), traitSet, inputs, this.joinFilter, this.rowType, this.joinConditions, this.joinTypes, this.postJoinFilter, this.hints);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = 1.0;
        double cpu = 0.0;
        double io = 0.0;
        for (RelNode input : this.inputs) {
            Double inputRowCount = mq.getRowCount(input);
            if (inputRowCount == null) {
                return planner.getCostFactory().makeHugeCost();
            }
            Double averageRowSize = mq.getAverageRowSize(input);
            double dAverageRowSize = averageRowSize == null ? 100.0 : averageRowSize;
            rowCount *= inputRowCount.doubleValue();
            cpu += inputRowCount.doubleValue();
            io += inputRowCount * dAverageRowSize;
        }
        return planner.getCostFactory().makeCost(rowCount, cpu, io);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    public List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    public List<? extends RexNode> getJoinConditions() {
        return this.joinConditions;
    }

    public @Nullable RexNode getPostJoinFilter() {
        return this.postJoinFilter;
    }

    public List<RelHint> getHints() {
        return this.hints;
    }

    public List<RelNode> getChildren() {
        return this.getInputs();
    }

    @Internal
    public static class Converter
    extends ConverterRule {
        public Converter(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            MultiJoin multiJoin = (MultiJoin)rel;
            List<RelNode> newInputs = multiJoin.getInputs().stream().map(input -> RelOptRule.convert(input, FlinkConventions.LOGICAL())).collect(Collectors.toList());
            return FlinkLogicalMultiJoin.create(multiJoin.getCluster(), newInputs, multiJoin.getJoinFilter(), multiJoin.getRowType(), multiJoin.getOuterJoinConditions(), multiJoin.getJoinTypes(), multiJoin.getPostJoinFilter(), Collections.emptyList());
        }
    }
}

