/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.MaterializedTableEnricher;
import org.apache.flink.table.catalog.MaterializedTableEnrichmentResult;

@Internal
public class DefaultMaterializedTableEnricher
implements MaterializedTableEnricher {
    private final IntervalFreshness defaultContinuousFreshness;
    private final IntervalFreshness defaultFullFreshness;
    private final Duration freshnessThreshold;

    public static DefaultMaterializedTableEnricher create(Duration defaultContinuousFreshness, Duration defaultFullFreshness, Duration freshnessThreshold) {
        IntervalFreshness continuousFreshness = IntervalFreshness.fromDuration(defaultContinuousFreshness);
        IntervalFreshness fullFreshness = IntervalFreshness.fromDuration(defaultFullFreshness);
        return new DefaultMaterializedTableEnricher(continuousFreshness, fullFreshness, freshnessThreshold);
    }

    private DefaultMaterializedTableEnricher(IntervalFreshness defaultContinuousFreshness, IntervalFreshness defaultFullFreshness, Duration freshnessThreshold) {
        this.defaultContinuousFreshness = defaultContinuousFreshness;
        this.defaultFullFreshness = defaultFullFreshness;
        this.freshnessThreshold = freshnessThreshold;
    }

    @Override
    public MaterializedTableEnrichmentResult enrich(CatalogMaterializedTable table) {
        IntervalFreshness finalFreshness = this.deriveFreshness(table);
        CatalogMaterializedTable.RefreshMode finalRefreshMode = this.deriveRefreshMode(table.getLogicalRefreshMode(), finalFreshness, this.freshnessThreshold);
        return new MaterializedTableEnrichmentResult(finalFreshness, finalRefreshMode);
    }

    private IntervalFreshness deriveFreshness(CatalogMaterializedTable table) {
        IntervalFreshness finalFreshness = table.getDefinitionFreshness() != null ? table.getDefinitionFreshness() : (table.getLogicalRefreshMode() == CatalogMaterializedTable.LogicalRefreshMode.FULL ? this.defaultFullFreshness : this.defaultContinuousFreshness);
        return finalFreshness;
    }

    public CatalogMaterializedTable.RefreshMode deriveRefreshMode(CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode, IntervalFreshness freshness, Duration threshold) {
        if (logicalRefreshMode != CatalogMaterializedTable.LogicalRefreshMode.FULL) {
            Duration definedFreshness = freshness.toDuration();
            if (logicalRefreshMode == CatalogMaterializedTable.LogicalRefreshMode.CONTINUOUS || definedFreshness.compareTo(threshold) < 0) {
                return CatalogMaterializedTable.RefreshMode.CONTINUOUS;
            }
        }
        IntervalFreshness.validateFreshnessForCron(freshness);
        return CatalogMaterializedTable.RefreshMode.FULL;
    }
}

