/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;

@Internal
public enum BuiltInPythonAggregateFunction implements PythonFunction
{
    AVG("AvgAggFunction"),
    COUNT1("Count1AggFunction"),
    COUNT("CountAggFunction"),
    FIRST_VALUE("FirstValueAggFunction"),
    FIRST_VALUE_RETRACT("FirstValueWithRetractAggFunction"),
    LAST_VALUE("LastValueAggFunction"),
    LAST_VALUE_RETRACT("LastValueWithRetractAggFunction"),
    LIST_AGG("ListAggFunction"),
    LIST_AGG_RETRACT("ListAggWithRetractAggFunction"),
    LIST_AGG_WS_RETRACT("ListAggWsWithRetractAggFunction"),
    MAX("MaxAggFunction"),
    MAX_RETRACT("MaxWithRetractAggFunction"),
    MIN("MinAggFunction"),
    MIN_RETRACT("MinWithRetractAggFunction"),
    INT_SUM0("IntSum0AggFunction"),
    FLOAT_SUM0("FloatSum0AggFunction"),
    DECIMAL_SUM0("DecimalSum0AggFunction"),
    SUM("SumAggFunction"),
    SUM_RETRACT("SumWithRetractAggFunction");

    private final byte[] payload;

    private BuiltInPythonAggregateFunction(String pythonFunctionName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(0);
        try {
            baos.write(pythonFunctionName.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception thrown when creating the python built-in aggregate function enum.", e);
        }
        this.payload = baos.toByteArray();
    }

    @Override
    public byte[] getSerializedPythonFunction() {
        return this.payload;
    }

    @Override
    public PythonEnv getPythonEnv() {
        return new PythonEnv(PythonEnv.ExecType.PROCESS);
    }
}

