/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.ModelAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.ModelNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterOperation;

@Internal
public class AlterModelRenameOperation
implements AlterOperation {
    private final ObjectIdentifier modelIdentifier;
    private final ObjectIdentifier newModelIdentifier;
    private final boolean ignoreIfNotExists;

    public AlterModelRenameOperation(ObjectIdentifier modelIdentifier, ObjectIdentifier newModelIdentifier, boolean ignoreIfNotExists) {
        this.modelIdentifier = modelIdentifier;
        this.newModelIdentifier = newModelIdentifier;
        this.ignoreIfNotExists = ignoreIfNotExists;
    }

    public ObjectIdentifier getModelIdentifier() {
        return this.modelIdentifier;
    }

    public ObjectIdentifier getNewModelIdentifier() {
        return this.newModelIdentifier;
    }

    public boolean ignoreIfNotExists() {
        return this.ignoreIfNotExists;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER MODEL %s%s RENAME TO %s", this.ignoreIfNotExists ? "IF EXISTS " : "", this.modelIdentifier.asSummaryString(), this.newModelIdentifier.asSummaryString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getModelIdentifier().getCatalogName());
            catalog.renameModel(this.getModelIdentifier().toObjectPath(), this.getNewModelIdentifier().getObjectName(), this.ignoreIfNotExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ModelAlreadyExistException | ModelNotExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

