/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterPartitionOperation;

@Internal
public class AlterPartitionPropertiesOperation
extends AlterPartitionOperation {
    private final CatalogPartition catalogPartition;

    public AlterPartitionPropertiesOperation(ObjectIdentifier tableIdentifier, CatalogPartitionSpec partitionSpec, CatalogPartition catalogPartition) {
        super(tableIdentifier, partitionSpec);
        this.catalogPartition = catalogPartition;
    }

    public CatalogPartition getCatalogPartition() {
        return this.catalogPartition;
    }

    @Override
    public String asSummaryString() {
        String spec = OperationUtils.formatPartitionSpec(this.partitionSpec);
        String properties = OperationUtils.formatProperties(this.catalogPartition.getProperties());
        return String.format("ALTER TABLE %s PARTITION (%s) SET (%s)", this.tableIdentifier.asSummaryString(), spec, properties);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getTableIdentifier().getCatalogName());
        try {
            catalog.alterPartition(this.getTableIdentifier().toObjectPath(), this.getPartitionSpec(), this.getCatalogPartition(), this.ignoreIfTableNotExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
    }
}

