/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public final class ColumnStats {
    public static final ColumnStats UNKNOWN = Builder.builder().build();
    private final Long ndv;
    private final Long nullCount;
    private final Double avgLen;
    private final Integer maxLen;
    private final Comparable<?> max;
    private final Comparable<?> min;

    public ColumnStats(Long ndv, Long nullCount, Double avgLen, Integer maxLen, Comparable<?> max, Comparable<?> min) {
        this.ndv = ndv;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
        this.max = max;
        this.min = min;
    }

    public Long getNdv() {
        return this.ndv;
    }

    public Long getNullCount() {
        return this.nullCount;
    }

    public Double getAvgLen() {
        return this.avgLen;
    }

    public Integer getMaxLen() {
        return this.maxLen;
    }

    public Comparable<?> getMax() {
        return this.max;
    }

    public Comparable<?> getMin() {
        return this.min;
    }

    public String toString() {
        ArrayList<CallSite> columnStats = new ArrayList<CallSite>();
        if (this.ndv != null) {
            columnStats.add((CallSite)((Object)("ndv=" + this.ndv)));
        }
        if (this.nullCount != null) {
            columnStats.add((CallSite)((Object)("nullCount=" + this.nullCount)));
        }
        if (this.avgLen != null) {
            columnStats.add((CallSite)((Object)("avgLen=" + this.avgLen)));
        }
        if (this.maxLen != null) {
            columnStats.add((CallSite)((Object)("maxLen=" + this.maxLen)));
        }
        if (this.max != null) {
            columnStats.add((CallSite)((Object)("max=" + String.valueOf(this.max))));
        }
        if (this.min != null) {
            columnStats.add((CallSite)((Object)("min=" + String.valueOf(this.min))));
        }
        String columnStatsStr = String.join((CharSequence)", ", columnStats);
        return "ColumnStats(" + columnStatsStr + ")";
    }

    public ColumnStats copy() {
        return new ColumnStats(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.max, this.min);
    }

    public ColumnStats merge(ColumnStats other, boolean isPartitionKey) {
        if (this == UNKNOWN || other == UNKNOWN) {
            return UNKNOWN;
        }
        Long ndv = isPartitionKey ? ColumnStats.combineIfNonNull(Long::sum, this.ndv, other.ndv) : ColumnStats.combineIfNonNull(Long::max, this.ndv, other.ndv);
        Long nullCount = ColumnStats.combineIfNonNull(Long::sum, this.nullCount, other.nullCount);
        Double avgLen = ColumnStats.combineIfNonNull((a1, a2) -> (a1 + a2) / 2.0, this.avgLen, other.avgLen);
        Integer maxLen = ColumnStats.combineIfNonNull(Math::max, this.maxLen, other.maxLen);
        Comparable<?> max = ColumnStats.combineIfNonNull((c1, c2) -> c1.compareTo(c2) > 0 ? c1 : c2, this.max, other.max);
        Comparable<?> min = ColumnStats.combineIfNonNull((c1, c2) -> c1.compareTo(c2) < 0 ? c1 : c2, this.min, other.min);
        return new ColumnStats(ndv, nullCount, avgLen, maxLen, max, min);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStats that = (ColumnStats)o;
        return Objects.equals(this.ndv, that.ndv) && Objects.equals(this.nullCount, that.nullCount) && Objects.equals(this.avgLen, that.avgLen) && Objects.equals(this.maxLen, that.maxLen) && Objects.equals(this.max, that.max) && Objects.equals(this.min, that.min);
    }

    public int hashCode() {
        return Objects.hash(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.max, this.min);
    }

    private static <T> T combineIfNonNull(BinaryOperator<T> op, T t1, T t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        return (T)op.apply(t1, t2);
    }

    @PublicEvolving
    public static class Builder {
        private Long ndv = null;
        private Long nullCount = null;
        private Double avgLen = null;
        private Integer maxLen = null;
        private Comparable<?> max;
        private Comparable<?> min;

        public static Builder builder() {
            return new Builder();
        }

        public Builder setNdv(Long ndv) {
            this.ndv = ndv;
            return this;
        }

        public Builder setNullCount(Long nullCount) {
            this.nullCount = nullCount;
            return this;
        }

        public Builder setAvgLen(Double avgLen) {
            this.avgLen = avgLen;
            return this;
        }

        public Builder setMaxLen(Integer maxLen) {
            this.maxLen = maxLen;
            return this;
        }

        public Builder setMax(Comparable<?> max) {
            this.max = max;
            return this;
        }

        public Builder setMin(Comparable<?> min) {
            this.min = min;
            return this;
        }

        public ColumnStats build() {
            return new ColumnStats(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.max, this.min);
        }
    }
}

