/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.sink.compactor.OutputStreamBasedFileCompactor;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

@PublicEvolving
public class ConcatFileCompactor
extends OutputStreamBasedFileCompactor {
    private static final int CHUNK_SIZE = 0x400000;
    private final byte[] fileDelimiter;

    public ConcatFileCompactor() {
        this(null);
    }

    public ConcatFileCompactor(@Nullable byte[] fileDelimiter) {
        this.fileDelimiter = fileDelimiter;
    }

    @Override
    protected void doCompact(List<Path> inputFiles, OutputStream outputStream) throws Exception {
        FileSystem fs = inputFiles.get(0).getFileSystem();
        for (Path input : inputFiles) {
            try (FSDataInputStream inputStream = fs.open(input);){
                this.copy((InputStream)inputStream, outputStream);
            }
            if (this.fileDelimiter == null) continue;
            outputStream.write(this.fileDelimiter);
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buf = new byte[0x400000];
        while ((length = in.read(buf)) > 0) {
            out.write(buf, 0, length);
        }
    }
}

