/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.GroupAggFunctionBase;
import org.apache.flink.table.runtime.operators.aggregate.utils.GroupAggHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class GroupAggFunction
extends GroupAggFunctionBase {
    private static final long serialVersionUID = -4767158666069797704L;
    private transient ValueState<RowData> accState = null;
    private transient SyncStateGroupAggHelper aggHelper = null;

    public GroupAggFunction(GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore, long stateRetentionTime) {
        super(genAggsHandler, genRecordEqualiser, accTypes, indexOfCountStar, generateUpdateBefore, stateRetentionTime);
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor accDesc = new ValueStateDescriptor("accState", accTypeInfo);
        if (this.ttlConfig.isEnabled()) {
            accDesc.enableTimeToLive(this.ttlConfig);
        }
        this.accState = this.getRuntimeContext().getState(accDesc);
        this.aggHelper = new SyncStateGroupAggHelper();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowData currentKey = (RowData)ctx.getCurrentKey();
        this.aggHelper.processElement(input, currentKey, (RowData)this.accState.value(), out);
    }

    private class SyncStateGroupAggHelper
    extends GroupAggHelper {
        public SyncStateGroupAggHelper() {
            super(GroupAggFunction.this.recordCounter, GroupAggFunction.this.generateUpdateBefore, GroupAggFunction.this.ttlConfig, GroupAggFunction.this.function, GroupAggFunction.this.equaliser);
        }

        @Override
        protected void updateAccumulatorsState(RowData accumulators) throws Exception {
            GroupAggFunction.this.accState.update((Object)accumulators);
        }

        @Override
        protected void clearAccumulatorsState() throws Exception {
            GroupAggFunction.this.accState.clear();
        }
    }
}

