/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.dynamicfiltering;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArrayComparator;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.runtime.source.event.SourceEventWrapper;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.connector.source.DynamicFilteringData;
import org.apache.flink.table.connector.source.DynamicFilteringEvent;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFilteringDataCollectorOperator
extends AbstractStreamOperator<Object>
implements OneInputStreamOperator<RowData, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicFilteringDataCollectorOperator.class);
    private final RowType dynamicFilteringFieldType;
    private final List<Integer> dynamicFilteringFieldIndices;
    private final long threshold;
    private final OperatorEventGateway operatorEventGateway;
    private transient TypeInformation<RowData> typeInfo;
    private transient TypeSerializer<RowData> serializer;
    private transient Set<byte[]> buffer;
    private transient long currentSize;
    private transient RowData.FieldGetter[] fieldGetters;

    public DynamicFilteringDataCollectorOperator(StreamOperatorParameters<Object> parameters, RowType dynamicFilteringFieldType, List<Integer> dynamicFilteringFieldIndices, long threshold, OperatorEventGateway operatorEventGateway) {
        super(parameters);
        this.dynamicFilteringFieldType = (RowType)Preconditions.checkNotNull((Object)dynamicFilteringFieldType);
        this.dynamicFilteringFieldIndices = (List)Preconditions.checkNotNull(dynamicFilteringFieldIndices);
        this.threshold = threshold;
        this.operatorEventGateway = (OperatorEventGateway)Preconditions.checkNotNull((Object)operatorEventGateway);
    }

    public void open() throws Exception {
        super.open();
        this.typeInfo = InternalTypeInfo.of(this.dynamicFilteringFieldType);
        this.serializer = this.typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        this.buffer = new TreeSet<byte[]>((arg_0, arg_1) -> ((BytePrimitiveArrayComparator)new BytePrimitiveArrayComparator(true)).compare(arg_0, arg_1));
        this.currentSize = 0L;
        this.fieldGetters = (RowData.FieldGetter[])IntStream.range(0, this.dynamicFilteringFieldIndices.size()).mapToObj(i -> RowData.createFieldGetter((LogicalType)this.dynamicFilteringFieldType.getTypeAt(i), (int)this.dynamicFilteringFieldIndices.get(i))).toArray(RowData.FieldGetter[]::new);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        if (this.exceedThreshold()) {
            return;
        }
        RowData value = (RowData)element.getValue();
        GenericRowData rowData = new GenericRowData(this.dynamicFilteringFieldIndices.size());
        for (int i = 0; i < this.dynamicFilteringFieldIndices.size(); ++i) {
            rowData.setField(i, this.fieldGetters[i].getFieldOrNull(value));
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            boolean duplicated;
            DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
            this.serializer.serialize((Object)rowData, (DataOutputView)wrapper);
            boolean bl = duplicated = !this.buffer.add(baos.toByteArray());
            if (duplicated) {
                return;
            }
            this.currentSize += (long)baos.size();
        }
        if (this.exceedThreshold()) {
            this.buffer.clear();
            LOG.warn("Collected data size exceeds the threshold, {} > {}, dynamic filtering is disabled.", (Object)this.currentSize, (Object)this.threshold);
        }
    }

    private boolean exceedThreshold() {
        return this.threshold > 0L && this.currentSize > this.threshold;
    }

    public void finish() throws Exception {
        if (this.exceedThreshold()) {
            LOG.info("Finish collecting. {} bytes are collected which exceeds the threshold {}. Sending empty data.", (Object)this.currentSize, (Object)this.threshold);
        } else {
            LOG.info("Finish collecting. {} bytes in {} rows are collected. Sending the data.", (Object)this.currentSize, (Object)this.buffer.size());
        }
        this.sendEvent();
    }

    private void sendEvent() {
        DynamicFilteringData dynamicFilteringData = this.exceedThreshold() ? new DynamicFilteringData(this.typeInfo, this.dynamicFilteringFieldType, Collections.emptyList(), false) : new DynamicFilteringData(this.typeInfo, this.dynamicFilteringFieldType, new ArrayList<byte[]>(this.buffer), true);
        DynamicFilteringEvent event = new DynamicFilteringEvent(dynamicFilteringData);
        this.operatorEventGateway.sendEventToCoordinator((OperatorEvent)new SourceEventWrapper((SourceEvent)event));
    }

    public void close() throws Exception {
        super.close();
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }
}

