/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.JoinRecordAsyncStateView;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.OuterJoinRecordAsyncStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.utils.OuterRecord;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.Preconditions;

public class AssociatedRecords {
    private final List<OuterRecord> records;

    private AssociatedRecords(List<OuterRecord> records) {
        Preconditions.checkNotNull(records);
        this.records = records;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public int size() {
        return this.records.size();
    }

    public Iterable<RowData> getRecords() {
        return new RecordsIterable(this.records);
    }

    public Iterable<OuterRecord> getOuterRecords() {
        return this.records;
    }

    public static AssociatedRecords fromSyncStateView(RowData input, boolean inputIsLeft, JoinRecordStateView otherSideStateView, JoinCondition condition) throws Exception {
        ArrayList<OuterRecord> associations = new ArrayList<OuterRecord>();
        if (otherSideStateView instanceof OuterJoinRecordStateView) {
            OuterJoinRecordStateView outerStateView = (OuterJoinRecordStateView)otherSideStateView;
            Iterable<Tuple2<RowData, Integer>> records = outerStateView.getRecordsAndNumOfAssociations();
            for (Tuple2<RowData, Integer> record : records) {
                boolean matched = inputIsLeft ? condition.apply(input, (RowData)record.f0) : condition.apply((RowData)record.f0, input);
                if (!matched) continue;
                associations.add(new OuterRecord((RowData)record.f0, (Integer)record.f1));
            }
        } else {
            Iterable<RowData> records = otherSideStateView.getRecords();
            for (RowData record : records) {
                boolean matched = inputIsLeft ? condition.apply(input, record) : condition.apply(record, input);
                if (!matched) continue;
                associations.add(new OuterRecord(record, -1));
            }
        }
        return new AssociatedRecords(associations);
    }

    public static StateFuture<AssociatedRecords> fromAsyncStateView(RowData input, boolean inputIsLeft, JoinRecordAsyncStateView otherSideAsyncStateView, JoinCondition joinCondition) throws Exception {
        Function<RowData, Boolean> conditionFunction = recordInState -> inputIsLeft ? joinCondition.apply(input, (RowData)recordInState) : joinCondition.apply((RowData)recordInState, input);
        if (otherSideAsyncStateView instanceof OuterJoinRecordAsyncStateView) {
            OuterJoinRecordAsyncStateView outerAsyncStateView = (OuterJoinRecordAsyncStateView)otherSideAsyncStateView;
            return outerAsyncStateView.findMatchedRecordsAndNumOfAssociations(conditionFunction).thenApply(AssociatedRecords::new);
        }
        return otherSideAsyncStateView.findMatchedRecords(conditionFunction).thenApply(AssociatedRecords::new);
    }

    private static final class RecordsIterable
    implements IterableIterator<RowData> {
        private final List<OuterRecord> records;
        private int index = 0;

        private RecordsIterable(List<OuterRecord> records) {
            this.records = records;
        }

        public Iterator<RowData> iterator() {
            this.index = 0;
            return this;
        }

        public boolean hasNext() {
            return this.index < this.records.size();
        }

        public RowData next() {
            RowData row = this.records.get((int)this.index).record;
            ++this.index;
            return row;
        }
    }
}

