/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.assigners;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.PanedWindowAssigner;
import org.apache.flink.util.IterableIterator;

public class CumulativeWindowAssigner
extends PanedWindowAssigner<TimeWindow>
implements InternalTimeWindowAssigner {
    private static final long serialVersionUID = 4895551155814656518L;
    private final long maxSize;
    private final long step;
    private final long offset;
    private final boolean isEventTime;

    protected CumulativeWindowAssigner(long maxSize, long step, long offset, boolean isEventTime) {
        if (maxSize <= 0L || step <= 0L) {
            throw new IllegalArgumentException("CumulativeWindowAssigner parameters must satisfy step > 0 and size > 0");
        }
        if (maxSize % step != 0L) {
            throw new IllegalArgumentException("CumulativeWindowAssigner requires size must be an integral multiple of step.");
        }
        this.maxSize = maxSize;
        this.step = step;
        this.offset = offset;
        this.isEventTime = isEventTime;
    }

    @Override
    public Collection<TimeWindow> assignWindows(RowData element, long timestamp) {
        long firstEnd;
        ArrayList<TimeWindow> windows = new ArrayList<TimeWindow>();
        long start = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.maxSize);
        long lastEnd = start + this.maxSize;
        for (long end = firstEnd = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.step) + this.step; end <= lastEnd; end += this.step) {
            windows.add(new TimeWindow(start, end));
        }
        return windows;
    }

    @Override
    public TimeWindow assignPane(Object element, long timestamp) {
        long start = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.step);
        return new TimeWindow(start, start + this.step);
    }

    @Override
    public Iterable<TimeWindow> splitIntoPanes(TimeWindow window) {
        return new PanesIterable(window.getStart(), window.getEnd(), this.step);
    }

    @Override
    public TimeWindow getLastWindow(TimeWindow pane) {
        long windowStart = TimeWindow.getWindowStartWithOffset(pane.getStart(), this.offset, this.maxSize);
        return new TimeWindow(windowStart, windowStart + this.maxSize);
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return this.isEventTime;
    }

    @Override
    public String toString() {
        return "CumulativeWindow(" + this.maxSize + ", " + this.step + ")";
    }

    public static CumulativeWindowAssigner of(Duration maxSize, Duration step) {
        return new CumulativeWindowAssigner(maxSize.toMillis(), step.toMillis(), 0L, true);
    }

    public CumulativeWindowAssigner withOffset(Duration offset) {
        return new CumulativeWindowAssigner(this.maxSize, this.step, offset.toMillis(), this.isEventTime);
    }

    @Override
    public CumulativeWindowAssigner withEventTime() {
        return new CumulativeWindowAssigner(this.maxSize, this.step, this.offset, true);
    }

    @Override
    public CumulativeWindowAssigner withProcessingTime() {
        return new CumulativeWindowAssigner(this.maxSize, this.step, this.offset, false);
    }

    private static class PanesIterable
    implements IterableIterator<TimeWindow> {
        private final long paneSize;
        private final long windowEnd;
        private long paneStart;
        private long paneEnd;

        PanesIterable(long windowStart, long windowEnd, long paneSize) {
            this.windowEnd = windowEnd;
            this.paneSize = paneSize;
            this.paneStart = windowStart;
            this.paneEnd = windowStart + paneSize;
        }

        public boolean hasNext() {
            return this.paneEnd <= this.windowEnd;
        }

        public TimeWindow next() {
            TimeWindow window = new TimeWindow(this.paneStart, this.paneEnd);
            this.paneStart += this.paneSize;
            this.paneEnd += this.paneSize;
            return window;
        }

        public Iterator<TimeWindow> iterator() {
            return this;
        }
    }
}

