/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.internal.cli.functions.AlterGatewaySenderFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterGatewaySenderCommand
extends SingleGfshCommand {
    private final AlterGatewaySenderFunction alterGatewaySenderFunction = new AlterGatewaySenderFunction();
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"alter gateway-sender"}, help="Alter some options for the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel alterGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="ID of the gateway sender.") String senderId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to alter the gateway sender option.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to alter the gateway sender option.") String[] onMember, @CliOption(key={"alert-threshold"}, help="The alert threshold for entries in a gateway sender's queue.") Integer alertThreshold, @CliOption(key={"batch-size"}, help="The batch size for the gateway sender.") Integer batchSize, @CliOption(key={"batch-time-interval"}, help="The batch time interval for the gateway sender.") Integer batchTimeInterval, @CliOption(key={"gateway-event-filter"}, specifiedDefaultValue="", optionContext="splittingRegex=,(?![^{]*\\})", help="The list of fully qualified class names of GatewayEventFilters (separated by commas) to be associated with the GatewaySender.\nThis serves as a callback for users to filter out events before dispatching to the remote distributed system.\nE.g gateway-event-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") ClassName[] gatewayEventFilters, @CliOption(key={"group-transaction-events"}, specifiedDefaultValue="true", help="Ensure that all the events of a transaction are sent in the same batch, i.e., they are never spread across different batches.\nOnly allowed on serial gateway senders with 1 dispatcher thread or on parallel ones.\nNote that in order to work for a transaction, the regions to which the transaction \nevents belong must be replicated by the same set of senders with this flag enabled.") Boolean groupTransactionEvents) throws EntityNotFoundException {
        Set<DistributedMember> dsMembers;
        if (this.getConfigurationPersistenceService() == null) {
            return ResultModel.createError("Cluster Configuration Service is not available. Please connect to a locator with running Cluster Configuration Service.");
        }
        String id = senderId.trim();
        CacheConfig.GatewaySender oldConfiguration = this.findGatewaySenderConfiguration(id);
        if (oldConfiguration == null) {
            String message = String.format("Cannot find a gateway sender with id '%s'.", id);
            throw new EntityNotFoundException(message);
        }
        if (alertThreshold != null && alertThreshold < 0) {
            return ResultModel.createError("alter-gateway-sender cannot be performed for --alert-threshold values smaller then 0.");
        }
        if (batchSize != null && batchSize < 1) {
            return ResultModel.createError("alter-gateway-sender cannot be performed for --batch-size values smaller then 1.");
        }
        if (batchTimeInterval != null && batchTimeInterval < -1) {
            return ResultModel.createError("alter-gateway-sender cannot be performed for --batch-time-interval values smaller then -1.");
        }
        if (groupTransactionEvents != null && groupTransactionEvents.booleanValue() && !oldConfiguration.mustGroupTransactionEvents().booleanValue()) {
            if (!(oldConfiguration.isParallel().booleanValue() || oldConfiguration.getDispatcherThreads() != null && Integer.parseInt(oldConfiguration.getDispatcherThreads()) <= 1)) {
                return ResultModel.createError("alter-gateway-sender cannot be performed for --group-transaction-events attribute if serial sender and dispatcher-threads is greater than 1.");
            }
            if (oldConfiguration.isEnableBatchConflation().booleanValue()) {
                return ResultModel.createError("alter-gateway-sender cannot be performed for --group-transaction-events attribute if batch-conflation is enabled.");
            }
        }
        if ((dsMembers = this.findMembers(onGroup, onMember)).isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        if (!this.verifyAllCurrentVersion(dsMembers)) {
            return ResultModel.createError("Alter Gateway Sender cannot be performed until all members are the current version");
        }
        CacheConfig.GatewaySender gwConfiguration = new CacheConfig.GatewaySender();
        gwConfiguration.setId(id);
        boolean modify = false;
        if (alertThreshold != null) {
            modify = true;
            gwConfiguration.setAlertThreshold(alertThreshold.toString());
        }
        if (batchSize != null) {
            modify = true;
            gwConfiguration.setBatchSize(batchSize.toString());
        }
        if (batchTimeInterval != null) {
            modify = true;
            gwConfiguration.setBatchTimeInterval(batchTimeInterval.toString());
        }
        if (groupTransactionEvents != null) {
            modify = true;
            gwConfiguration.setGroupTransactionEvents(groupTransactionEvents);
        }
        if (gatewayEventFilters != null) {
            modify = true;
            if (gatewayEventFilters.length == 1 && gatewayEventFilters[0].getClassName().isEmpty()) {
                gwConfiguration.getGatewayEventFilters();
            } else {
                gwConfiguration.getGatewayEventFilters().addAll(Arrays.stream(gatewayEventFilters).map(l -> new DeclarableType(l.getClassName())).collect(Collectors.toList()));
            }
        }
        if (!modify) {
            return ResultModel.createError("Please provide a relevant parameter(s)");
        }
        GatewaySenderFunctionArgs gatewaySenderFunctionArgs = new GatewaySenderFunctionArgs(gwConfiguration);
        List<CliFunctionResult> gatewaySenderAlterResults = this.executeAndGetFunctionResult((Function<?>)this.alterGatewaySenderFunction, gatewaySenderFunctionArgs, dsMembers);
        ResultModel resultModel = ResultModel.createMemberStatusResult(gatewaySenderAlterResults);
        resultModel.setConfigObject(gwConfiguration);
        return resultModel;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        List gwSenders = config.getGatewaySenders();
        if (gwSenders.isEmpty()) {
            return false;
        }
        boolean gwConfigsHaveBeenUpdated = false;
        CacheConfig.GatewaySender gwConfiguration = (CacheConfig.GatewaySender)configObject;
        String gwId = gwConfiguration.getId();
        for (CacheConfig.GatewaySender sender : gwSenders) {
            if (!gwId.equals(sender.getId())) continue;
            gwConfigsHaveBeenUpdated = true;
            if (StringUtils.isNotBlank((CharSequence)gwConfiguration.getBatchSize())) {
                sender.setBatchSize(gwConfiguration.getBatchSize());
            }
            if (StringUtils.isNotBlank((CharSequence)gwConfiguration.getBatchTimeInterval())) {
                sender.setBatchTimeInterval(gwConfiguration.getBatchTimeInterval());
            }
            if (StringUtils.isNotBlank((CharSequence)gwConfiguration.getAlertThreshold())) {
                sender.setAlertThreshold(gwConfiguration.getAlertThreshold());
            }
            if (gwConfiguration.mustGroupTransactionEvents() != null) {
                sender.setGroupTransactionEvents(gwConfiguration.mustGroupTransactionEvents());
            }
            if (!gwConfiguration.areGatewayEventFiltersUpdated()) continue;
            if (!sender.getGatewayEventFilters().isEmpty()) {
                sender.getGatewayEventFilters().clear();
            }
            if (gwConfiguration.getGatewayEventFilters().isEmpty()) continue;
            sender.getGatewayEventFilters().addAll(gwConfiguration.getGatewayEventFilters());
        }
        return gwConfigsHaveBeenUpdated;
    }

    private CacheConfig.GatewaySender findGatewaySenderConfiguration(String gwId) {
        CacheConfig.GatewaySender gwsender = null;
        InternalConfigurationPersistenceService ccService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (ccService == null) {
            return null;
        }
        Set groups = ccService.getGroups();
        for (String group : groups) {
            List gwSendersList = ccService.getCacheConfig(group).getGatewaySenders();
            if (gwSendersList.isEmpty()) continue;
            for (CacheConfig.GatewaySender sender : gwSendersList) {
                if (!sender.getId().equals(gwId)) continue;
                return sender;
            }
        }
        return gwsender;
    }

    boolean verifyAllCurrentVersion(Set<DistributedMember> members) {
        return members.stream().allMatch(member -> ((InternalDistributedMember)member).getVersion().equals(KnownVersion.CURRENT));
    }
}

