/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.Statistics;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteStatResource;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class FetchStatsResponse
extends AdminResponse {
    private RemoteStatResource[] stats;

    public static FetchStatsResponse create(DistributionManager dm, InternalDistributedMember recipient, String statisticsTypeName) {
        FetchStatsResponse response = new FetchStatsResponse();
        response.setRecipient(recipient);
        List<Statistics> statsList = dm.getSystem().getStatisticsManager().getStatsList();
        response.stats = statisticsTypeName == null ? (RemoteStatResource[])statsList.stream().map(RemoteStatResource::new).toArray(RemoteStatResource[]::new) : (RemoteStatResource[])statsList.stream().filter(s -> s.getType().getName().equals(statisticsTypeName)).map(RemoteStatResource::new).toArray(RemoteStatResource[]::new);
        return response;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public int getDSFID() {
        return 1030;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.stats, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.stats = (RemoteStatResource[])DataSerializer.readObject(in);
    }

    public RemoteStatResource[] getAllStats(RemoteGemFireVM vm) {
        for (RemoteStatResource stat : this.stats) {
            stat.setGemFireVM(vm);
        }
        return this.stats;
    }

    public RemoteStatResource[] getStats(RemoteGemFireVM vm) {
        ArrayList<RemoteStatResource> statList = new ArrayList<RemoteStatResource>();
        for (RemoteStatResource stat : this.stats) {
            stat.setGemFireVM(vm);
            statList.add(stat);
        }
        return statList.toArray(new RemoteStatResource[0]);
    }

    @Override
    public String toString() {
        return "FetchStatsResponse from " + this.getRecipient() + " stats.length=" + this.stats.length;
    }
}

