/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.tcp.BaseMsgStreamer;
import org.apache.geode.internal.tcp.ConnectExceptions;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgStreamer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsgStreamerList
implements BaseMsgStreamer {
    private static final Logger logger = LogService.getLogger();
    @NotNull
    private final @NotNull List<@NotNull MsgStreamer> streamers;

    MsgStreamerList(@NotNull @NotNull List<@NotNull MsgStreamer> streamers) {
        this.streamers = streamers;
    }

    @Override
    public void reserveConnections(long startTime, long ackTimeout, long ackSDTimeout) {
        for (MsgStreamer streamer : this.streamers) {
            streamer.reserveConnections(startTime, ackTimeout, ackSDTimeout);
        }
    }

    @Override
    public int writeMessage() throws IOException {
        int result = 0;
        RuntimeException runtimeException = null;
        IOException ioException = null;
        for (MsgStreamer streamer : this.streamers) {
            if (runtimeException != null) {
                streamer.release();
                continue;
            }
            try {
                result += streamer.writeMessage();
            }
            catch (RuntimeException e) {
                runtimeException = e;
            }
            catch (IOException e) {
                ioException = e;
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (ioException != null) {
            throw ioException;
        }
        return result;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Connection> getSentConnections() {
        if (this.streamers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (MsgStreamer streamer : this.streamers) {
            connections.addAll(streamer.getSentConnections());
        }
        return connections;
    }

    @Override
    @Nullable
    public ConnectExceptions getConnectExceptions() {
        ConnectExceptions ce = null;
        for (MsgStreamer streamer : this.streamers) {
            if (ce == null) {
                ce = streamer.getConnectExceptions();
                continue;
            }
            ConnectExceptions e = streamer.getConnectExceptions();
            if (e == null) continue;
            List<InternalDistributedMember> members = e.getMembers();
            List<Throwable> exs = e.getCauses();
            for (int i = 0; i < exs.size(); ++i) {
                ce.addFailure(members.get(i), exs.get(i));
            }
        }
        return ce;
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (MsgStreamer m : this.streamers) {
            try {
                m.close();
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                logger.fatal("Unknown error closing streamer: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

