/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.util.Timer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.membership.api.Authenticator;
import org.apache.geode.distributed.internal.membership.api.MemberDisconnectedException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifierFactory;
import org.apache.geode.distributed.internal.membership.api.MemberStartupException;
import org.apache.geode.distributed.internal.membership.api.MembershipClosedException;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipStatistics;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.MemberIdentifierImpl;
import org.apache.geode.distributed.internal.membership.gms.fd.GMSHealthMonitor;
import org.apache.geode.distributed.internal.membership.gms.interfaces.HealthMonitor;
import org.apache.geode.distributed.internal.membership.gms.interfaces.JoinLeave;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Locator;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Manager;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Messenger;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewResponse;
import org.apache.geode.distributed.internal.membership.gms.locator.MembershipLocatorImpl;
import org.apache.geode.distributed.internal.membership.gms.membership.GMSJoinLeave;
import org.apache.geode.distributed.internal.membership.gms.messages.FinalCheckPassedMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HeartbeatMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HeartbeatRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.InstallViewMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinResponseMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.LeaveRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.NetworkPartitionMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.RemoveMemberMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectMembersMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.ViewAckMessage;
import org.apache.geode.distributed.internal.membership.gms.messenger.JGroupsMessenger;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.serialization.DSFIDSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedIdRegistrant;
import org.apache.geode.internal.serialization.DataSerializableFixedIdRegistrar;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class Services<ID extends MemberIdentifier>
implements DataSerializableFixedIdRegistrant {
    private static final Logger logger = LogService.getLogger();
    private final Manager<ID> manager;
    private final JoinLeave<ID> joinLeave;
    private final HealthMonitor<ID> healthMon;
    private final Messenger<ID> messenger;
    private final Authenticator<ID> auth;
    private final MembershipConfig config;
    private final MembershipStatistics stats;
    private final Stopper cancelCriterion;
    private final DSFIDSerializer serializer;
    private final MemberIdentifierFactory<ID> memberFactory;
    private volatile boolean stopping;
    private volatile boolean stopped;
    private volatile Exception shutdownCause;
    private Locator<ID> locator;
    private MembershipLocator<ID> membershipLocator;
    private final Timer timer = new Timer("Geode Membership Timer", true);

    public static Logger getLogger() {
        return logger;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Services() {
        this.cancelCriterion = new Stopper();
        this.stats = null;
        this.config = null;
        this.manager = null;
        this.joinLeave = null;
        this.healthMon = null;
        this.messenger = null;
        this.auth = null;
        this.serializer = null;
        this.memberFactory = null;
    }

    public Services(Manager<ID> membershipManager, MembershipStatistics stats, Authenticator<ID> authenticator, MembershipConfig membershipConfig, DSFIDSerializer serializer, MemberIdentifierFactory<ID> memberFactory, TcpClient locatorClient, TcpSocketCreator socketCreator) {
        this.cancelCriterion = new Stopper();
        this.stats = stats;
        this.config = membershipConfig;
        this.manager = membershipManager;
        this.joinLeave = new GMSJoinLeave(locatorClient);
        this.healthMon = new GMSHealthMonitor(socketCreator);
        this.messenger = new JGroupsMessenger();
        this.auth = authenticator;
        this.serializer = serializer;
        this.memberFactory = memberFactory;
    }

    public void register(DataSerializableFixedIdRegistrar registrar) {
        Services.registerSerializables(registrar);
    }

    @VisibleForTesting
    public static void registerSerializables(DataSerializableFixedIdRegistrar serializer) {
        serializer.register(-158, FinalCheckPassedMessage.class);
        serializer.register(-157, NetworkPartitionMessage.class);
        serializer.register(-153, RemoveMemberMessage.class);
        serializer.register(-154, HeartbeatRequestMessage.class);
        serializer.register(-155, HeartbeatMessage.class);
        serializer.register(-156, SuspectMembersMessage.class);
        serializer.register(-152, LeaveRequestMessage.class);
        serializer.register(-151, ViewAckMessage.class);
        serializer.register(-150, InstallViewMessage.class);
        serializer.register(-148, GMSMembershipView.class);
        serializer.register(-147, GetViewRequest.class);
        serializer.register(-146, GetViewResponse.class);
        serializer.register(-145, FindCoordinatorRequest.class);
        serializer.register(-144, FindCoordinatorResponse.class);
        serializer.register(-143, JoinResponseMessage.class);
        serializer.register(-142, JoinRequestMessage.class);
        serializer.register(2184, MemberIdentifierImpl.class);
    }

    public void init() throws MembershipConfigurationException {
        this.messenger.init(this);
        this.manager.init(this);
        this.joinLeave.init(this);
        this.healthMon.init(this);
    }

    public void start() throws MemberStartupException {
        boolean started = false;
        try {
            logger.info("Starting membership services");
            logger.debug("starting Messenger");
            this.messenger.start();
            logger.debug("starting JoinLeave");
            this.joinLeave.start();
            logger.debug("starting HealthMonitor");
            this.healthMon.start();
            logger.debug("starting Manager");
            this.manager.start();
            this.messenger.started();
            this.joinLeave.started();
            this.healthMon.started();
            this.manager.started();
            if (this.membershipLocator != null) {
                MembershipLocatorImpl locatorImpl = (MembershipLocatorImpl)this.membershipLocator;
                locatorImpl.setServices(this);
            }
            logger.debug("All membership services have been started");
            started = true;
        }
        catch (RuntimeException e) {
            logger.fatal("Unexpected exception while booting membership services", (Throwable)e);
            throw e;
        }
        finally {
            if (!started) {
                this.manager.stop();
                this.healthMon.stop();
                this.joinLeave.stop();
                this.messenger.stop();
                this.timer.cancel();
            }
        }
        try {
            this.manager.joinDistributedSystem();
        }
        catch (Throwable e) {
            this.stop();
            throw e;
        }
    }

    public void setLocalAddress(ID address) {
        this.messenger.setLocalAddress(address);
        this.joinLeave.setLocalAddress(address);
        this.healthMon.setLocalAddress(address);
        this.manager.setLocalAddress(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emergencyClose() {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        logger.info("Stopping membership services");
        this.timer.cancel();
        try {
            this.joinLeave.emergencyClose();
        }
        finally {
            try {
                this.healthMon.emergencyClose();
            }
            finally {
                try {
                    this.messenger.emergencyClose();
                }
                finally {
                    try {
                        this.manager.emergencyClose();
                    }
                    finally {
                        this.cancelCriterion.cancel("Membership services are shut down");
                        this.stopped = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopping) {
            return;
        }
        logger.info("Stopping membership services");
        this.stopping = true;
        try {
            this.timer.cancel();
        }
        finally {
            try {
                this.joinLeave.stop();
            }
            finally {
                try {
                    this.healthMon.stop();
                }
                finally {
                    try {
                        this.messenger.stop();
                    }
                    finally {
                        try {
                            this.manager.stop();
                        }
                        finally {
                            this.cancelCriterion.cancel("Membership services are shut down");
                            this.stopped = true;
                        }
                    }
                }
            }
        }
    }

    public Authenticator<ID> getAuthenticator() {
        return this.auth;
    }

    public void installView(GMSMembershipView<ID> v) {
        if (this.locator != null) {
            this.locator.installView(v);
        }
        this.healthMon.installView(v);
        this.messenger.installView(v);
        this.manager.installView(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberSuspected(ID initiator, ID suspect, String reason) {
        try {
            this.joinLeave.memberSuspected(initiator, suspect, reason);
        }
        finally {
            try {
                this.healthMon.memberSuspected(initiator, suspect, reason);
            }
            finally {
                try {
                    this.messenger.memberSuspected(initiator, suspect, reason);
                }
                finally {
                    this.manager.memberSuspected(initiator, suspect, reason);
                }
            }
        }
    }

    public Manager<ID> getManager() {
        return this.manager;
    }

    public void setLocators(Locator<ID> locator, MembershipLocator<ID> membershipLocator) {
        this.locator = locator;
        this.membershipLocator = membershipLocator;
    }

    public Locator<ID> getLocator() {
        return this.locator;
    }

    public JoinLeave<ID> getJoinLeave() {
        return this.joinLeave;
    }

    public HealthMonitor<ID> getHealthMonitor() {
        return this.healthMon;
    }

    public MembershipConfig getConfig() {
        return this.config;
    }

    public Messenger<ID> getMessenger() {
        return this.messenger;
    }

    public MembershipStatistics getStatistics() {
        return this.stats;
    }

    public MemberIdentifierFactory<ID> getMemberFactory() {
        return this.memberFactory;
    }

    public Stopper getCancelCriterion() {
        return this.cancelCriterion;
    }

    public void setShutdownCause(Exception e) {
        this.shutdownCause = e;
    }

    public Exception getShutdownCause() {
        return this.shutdownCause;
    }

    public boolean isShutdownDueToForcedDisconnect() {
        return this.shutdownCause instanceof MemberDisconnectedException;
    }

    public boolean isAutoReconnectEnabled() {
        return !this.getConfig().getDisableAutoReconnect();
    }

    public DSFIDSerializer getSerializer() {
        return this.serializer;
    }

    public class Stopper {
        volatile String reasonForStopping = null;

        public void cancel(String reason) {
            this.reasonForStopping = reason;
        }

        public String cancelInProgress() {
            if (Services.this.shutdownCause != null) {
                return Services.this.shutdownCause.toString();
            }
            return this.reasonForStopping;
        }

        public RuntimeException generateCancelledException(Throwable e) {
            if (Services.this.shutdownCause instanceof MemberDisconnectedException) {
                MembershipClosedException newException = new MembershipClosedException("membership shutdown", e);
                throw newException;
            }
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            if (e == null) {
                return new MembershipClosedException(reason);
            }
            return new MembershipClosedException(reason, e);
        }

        public boolean isCancelInProgress() {
            return this.cancelInProgress() != null;
        }

        public void checkCancelInProgress(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return;
            }
            throw this.generateCancelledException(e);
        }
    }
}

