/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.condition.OperatingSystem;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import java.util.Locale;
import org.grails.forge.cli.CommonOptionsMixin;
import org.grails.forge.io.ConsoleOutput;
import picocli.CommandLine;

public class BaseCommand
implements ConsoleOutput {
    @CommandLine.Spec
    @ReflectiveAccess
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    @ReflectiveAccess
    protected CommonOptionsMixin commonOptions = new CommonOptionsMixin();

    @Override
    public void out(String message) {
        this.spec.commandLine().getOut().println(CommandLine.Help.Ansi.AUTO.string(message));
    }

    @Override
    public void err(String message) {
        this.spec.commandLine().getErr().println(CommandLine.Help.Ansi.AUTO.string("@|bold,red | Error|@ " + message));
    }

    @Override
    public void warning(String message) {
        this.spec.commandLine().getOut().println(CommandLine.Help.Ansi.AUTO.string("@|bold,red | Warning|@ " + message));
    }

    @Override
    public void green(String message) {
        this.spec.commandLine().getOut().println(CommandLine.Help.Ansi.AUTO.string("@|bold,green " + message + "|@"));
    }

    @Override
    public void red(String message) {
        this.spec.commandLine().getOut().println(CommandLine.Help.Ansi.AUTO.string("@|bold,red " + message + "|@"));
    }

    @Override
    public boolean showStacktrace() {
        return this.commonOptions.showStacktrace;
    }

    @Override
    public boolean verbose() {
        return this.commonOptions.verbose;
    }

    @Nullable
    public org.grails.forge.application.OperatingSystem getOperatingSystem() {
        OperatingSystem operatingSystem = OperatingSystem.getCurrent();
        if (operatingSystem.isMacOs()) {
            String osArch = CachedEnvironment.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            if (osArch.equals("aarch64")) {
                return org.grails.forge.application.OperatingSystem.MACOS_ARCH64;
            }
            return org.grails.forge.application.OperatingSystem.MACOS;
        }
        if (operatingSystem.isLinux()) {
            return org.grails.forge.application.OperatingSystem.LINUX;
        }
        if (operatingSystem.isWindows()) {
            return org.grails.forge.application.OperatingSystem.WINDOWS;
        }
        if (operatingSystem.isSolaris()) {
            return org.grails.forge.application.OperatingSystem.SOLARIS;
        }
        return null;
    }
}

