/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions.transforms;

import java.util.Arrays;
import java.util.Objects;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.partitions.ListPartition;
import org.apache.gravitino.rel.partitions.RangePartition;
import org.apache.gravitino.shaded.com.google.common.collect.ObjectArrays;

public class Transforms {
    public static final Transform[] EMPTY_TRANSFORM = new Transform[0];
    public static final String NAME_OF_IDENTITY = "identity";
    public static final String NAME_OF_YEAR = "year";
    public static final String NAME_OF_MONTH = "month";
    public static final String NAME_OF_DAY = "day";
    public static final String NAME_OF_HOUR = "hour";
    public static final String NAME_OF_BUCKET = "bucket";
    public static final String NAME_OF_TRUNCATE = "truncate";
    public static final String NAME_OF_LIST = "list";
    public static final String NAME_OF_RANGE = "range";

    public static IdentityTransform identity(String[] fieldName) {
        return Transforms.identity(NamedReference.field(fieldName));
    }

    public static IdentityTransform identity(String columnName) {
        return Transforms.identity(new String[]{columnName});
    }

    public static YearTransform year(String[] fieldName) {
        return Transforms.year(NamedReference.field(fieldName));
    }

    public static YearTransform year(String columnName) {
        return Transforms.year(new String[]{columnName});
    }

    public static MonthTransform month(String[] fieldName) {
        return Transforms.month(NamedReference.field(fieldName));
    }

    public static MonthTransform month(String columnName) {
        return Transforms.month(new String[]{columnName});
    }

    public static DayTransform day(String[] fieldName) {
        return Transforms.day(NamedReference.field(fieldName));
    }

    public static DayTransform day(String columnName) {
        return Transforms.day(new String[]{columnName});
    }

    public static HourTransform hour(String[] fieldName) {
        return Transforms.hour(NamedReference.field(fieldName));
    }

    public static HourTransform hour(String columnName) {
        return Transforms.hour(new String[]{columnName});
    }

    public static BucketTransform bucket(int numBuckets, String[] ... fieldNames) {
        return new BucketTransform(Literals.integerLiteral(numBuckets), (NamedReference[])Arrays.stream(fieldNames).map(NamedReference::field).toArray(NamedReference[]::new));
    }

    public static ListTransform list(String[] ... fieldNames) {
        return Transforms.list(fieldNames, new ListPartition[0]);
    }

    public static ListTransform list(String[][] fieldNames, ListPartition[] assignments) {
        return new ListTransform((NamedReference[])Arrays.stream(fieldNames).map(NamedReference::field).toArray(NamedReference[]::new), assignments);
    }

    public static RangeTransform range(String[] fieldName) {
        return Transforms.range(fieldName, new RangePartition[0]);
    }

    public static RangeTransform range(String[] fieldName, RangePartition[] assignments) {
        return new RangeTransform(NamedReference.field(fieldName), assignments);
    }

    public static TruncateTransform truncate(int width, String[] fieldName) {
        return new TruncateTransform(Literals.integerLiteral(width), NamedReference.field(fieldName));
    }

    public static TruncateTransform truncate(int width, String columnName) {
        return Transforms.truncate(width, new String[]{columnName});
    }

    public static ApplyTransform apply(String name, Expression[] arguments) {
        return new ApplyTransform(name, arguments);
    }

    private static IdentityTransform identity(NamedReference ref) {
        return new IdentityTransform(ref);
    }

    private static YearTransform year(NamedReference ref) {
        return new YearTransform(ref);
    }

    private static MonthTransform month(NamedReference ref) {
        return new MonthTransform(ref);
    }

    private static DayTransform day(NamedReference ref) {
        return new DayTransform(ref);
    }

    private static HourTransform hour(NamedReference ref) {
        return new HourTransform(ref);
    }

    private Transforms() {
    }

    public static final class IdentityTransform
    extends Transform.SingleFieldTransform {
        private IdentityTransform(NamedReference ref) {
            this.ref = ref;
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_IDENTITY;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static final class YearTransform
    extends Transform.SingleFieldTransform {
        private YearTransform(NamedReference ref) {
            this.ref = ref;
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_YEAR;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static final class MonthTransform
    extends Transform.SingleFieldTransform {
        private MonthTransform(NamedReference ref) {
            this.ref = ref;
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_MONTH;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static final class DayTransform
    extends Transform.SingleFieldTransform {
        private DayTransform(NamedReference ref) {
            this.ref = ref;
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_DAY;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static final class HourTransform
    extends Transform.SingleFieldTransform {
        private HourTransform(NamedReference ref) {
            this.ref = ref;
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_HOUR;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static final class BucketTransform
    implements Transform {
        private final Literal<Integer> numBuckets;
        private final NamedReference[] fields;

        private BucketTransform(Literal<Integer> numBuckets, NamedReference[] fields) {
            this.numBuckets = numBuckets;
            this.fields = fields;
        }

        public int numBuckets() {
            return this.numBuckets.value();
        }

        public String[][] fieldNames() {
            return (String[][])Arrays.stream(this.fields).map(NamedReference::fieldName).toArray(x$0 -> new String[x$0][]);
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_BUCKET;
        }

        @Override
        public Expression[] arguments() {
            return ObjectArrays.concat(new Expression[]{this.numBuckets}, this.fields, Expression.class);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketTransform that = (BucketTransform)o;
            return Objects.equals(this.numBuckets, that.numBuckets) && Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            int result = Objects.hash(this.numBuckets);
            result = 31 * result + Arrays.hashCode(this.fields);
            return result;
        }
    }

    public static final class ListTransform
    implements Transform {
        private final NamedReference[] fields;
        private final ListPartition[] assignments;

        private ListTransform(NamedReference[] fields) {
            this.fields = fields;
            this.assignments = new ListPartition[0];
        }

        private ListTransform(NamedReference[] fields, ListPartition[] assignments) {
            this.fields = fields;
            this.assignments = assignments;
        }

        public String[][] fieldNames() {
            return (String[][])Arrays.stream(this.fields).map(NamedReference::fieldName).toArray(x$0 -> new String[x$0][]);
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_LIST;
        }

        @Override
        public Expression[] arguments() {
            return this.fields;
        }

        public ListPartition[] assignments() {
            return this.assignments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListTransform that = (ListTransform)o;
            return Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fields);
        }
    }

    public static final class RangeTransform
    implements Transform {
        private final NamedReference field;
        private final RangePartition[] assignments;

        private RangeTransform(NamedReference field) {
            this.field = field;
            this.assignments = new RangePartition[0];
        }

        private RangeTransform(NamedReference field, RangePartition[] assignments) {
            this.field = field;
            this.assignments = assignments;
        }

        public String[] fieldName() {
            return this.field.fieldName();
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_RANGE;
        }

        @Override
        public Expression[] arguments() {
            return new Expression[]{this.field};
        }

        public RangePartition[] assignments() {
            return this.assignments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangeTransform that = (RangeTransform)o;
            return Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field);
        }
    }

    public static final class TruncateTransform
    implements Transform {
        private final Literal<Integer> width;
        private final NamedReference field;

        private TruncateTransform(Literal<Integer> width, NamedReference field) {
            this.width = width;
            this.field = field;
        }

        public int width() {
            return this.width.value();
        }

        public String[] fieldName() {
            return this.field.fieldName();
        }

        @Override
        public String name() {
            return Transforms.NAME_OF_TRUNCATE;
        }

        @Override
        public Expression[] arguments() {
            return new Expression[]{this.width, this.field};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncateTransform that = (TruncateTransform)o;
            return Objects.equals(this.width, that.width) && Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.width, this.field);
        }
    }

    public static final class ApplyTransform
    implements Transform {
        private final String name;
        private final Expression[] arguments;

        private ApplyTransform(String name, Expression[] arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Expression[] arguments() {
            return this.arguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplyTransform that = (ApplyTransform)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }
    }
}

