/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import org.snmp4j.PDU;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TreeUtils;

public abstract class RetrievalEvent
extends EventObject {
    public static final int STATUS_OK = 0;
    public static final int STATUS_TIMEOUT = -1;
    public static final int STATUS_WRONG_ORDER = -2;
    public static final int STATUS_REPORT = -3;
    public static final int STATUS_EXCEPTION = -4;
    private static final long serialVersionUID = 6592701899052543606L;
    protected VariableBinding[] vbs;
    protected int status = 0;
    protected Object userObject;
    protected Exception exception;
    protected PDU reportPDU;

    protected RetrievalEvent(EventListener source, Object userObject) {
        super(source);
        this.userObject = userObject;
    }

    public RetrievalEvent(TreeUtils.TreeRequest source, Object userObject, int status) {
        this(source, userObject);
        this.status = status;
    }

    public RetrievalEvent(TreeUtils.TreeRequest source, Object userObject, Exception exception) {
        this(source, userObject);
        this.exception = exception;
        this.status = -4;
    }

    public RetrievalEvent(TreeUtils.TreeRequest source, Object userObject, PDU report) {
        this(source, userObject);
        this.reportPDU = report;
        this.status = -3;
    }

    public RetrievalEvent(ResponseListener source, Object userObject, VariableBinding[] variableBindings) {
        this(source, userObject);
        this.vbs = variableBindings;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isError() {
        return this.status != 0;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Exception getException() {
        return this.exception;
    }

    public PDU getReportPDU() {
        return this.reportPDU;
    }

    public String getErrorMessage() {
        switch (this.status) {
            case -4: {
                return this.exception.getMessage();
            }
            case -3: {
                return "Report: " + this.reportPDU.get(0);
            }
            case -1: {
                return "Request timed out.";
            }
            case -2: {
                return "Agent did not return variable bindings in lexicographic order.";
            }
        }
        return PDU.toErrorStatusText(this.status);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[vbs=" + (String)(this.vbs == null ? "null" : "" + Arrays.asList(this.vbs)) + ",status=" + this.status + ",exception=" + this.exception + ",report=" + this.reportPDU + "]";
    }
}

